/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.preferences;

import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.MavenArtifact;
import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.repository.Repository;
import com.oracle.javafx.scenebuilder.kit.preferences.MavenPreferences;
import com.oracle.javafx.scenebuilder.kit.preferences.PreferencesRecordArtifact;
import com.oracle.javafx.scenebuilder.kit.preferences.PreferencesRecordGlobalBase;
import com.oracle.javafx.scenebuilder.kit.preferences.PreferencesRecordRepository;
import com.oracle.javafx.scenebuilder.kit.preferences.RepositoryPreferences;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public abstract class PreferencesControllerBase {
    private static final String DOCUMENTS = "DOCUMENTS";
    private static final String ARTIFACTS = "ARTIFACTS";
    private static final String REPOSITORIES = "REPOSITORIES";
    public static final String ROOT_CONTAINER_HEIGHT = "ROOT_CONTAINER_HEIGHT";
    public static final String ROOT_CONTAINER_WIDTH = "ROOT_CONTAINER_WIDTH";
    public static final String BACKGROUND_IMAGE = "BACKGROUND_IMAGE";
    public static final String ALIGNMENT_GUIDES_COLOR = "ALIGNMENT_GUIDES_COLOR";
    public static final String PARENT_RING_COLOR = "PARENT_RING_COLOR";
    public static final String LIBRARY_DISPLAY_OPTION = "LIBRARY_DISPLAY_OPTION";
    public static final String HIERARCHY_DISPLAY_OPTION = "HIERARCHY_DISPLAY_OPTION";
    public static final String ACCORDION_ANIMATION = "ACCORDION_ANIMATION";
    public static final String WILDCARD_IMPORT = "WILDCARD_IMPORT";
    public static final String ALTERNATE_TEXT_INPUT_PASTE = "ALTERNATE_TEXT_INPUT_PASTE";
    public static final String PATH = "path";
    public static final String X_POS = "X";
    public static final String Y_POS = "Y";
    public static final String STAGE_HEIGHT = "height";
    public static final String STAGE_WIDTH = "width";
    public static final String SCENE_STYLE_SHEETS = "sceneStyleSheets";
    public static final String I18N_RESOURCE = "I18NResource";
    public static final String THEME = "theme";
    protected final Preferences applicationRootPreferences;
    protected final PreferencesRecordGlobalBase recordGlobal;
    protected final Preferences documentsRootPreferences;
    protected final Preferences artifactsRootPreferences;
    protected final Preferences repositoriesRootPreferences;
    protected final MavenPreferences mavenPreferences;
    protected final RepositoryPreferences repositoryPreferences;

    public PreferencesControllerBase(String basePrefNodeName, PreferencesRecordGlobalBase recordGlobal) {
        String[] childrenNames;
        this.applicationRootPreferences = Preferences.userNodeForPackage(this.getClass()).node(basePrefNodeName);
        this.recordGlobal = recordGlobal;
        recordGlobal.setApplicationRootPreferences(this.applicationRootPreferences);
        this.documentsRootPreferences = this.applicationRootPreferences.node(DOCUMENTS);
        this.artifactsRootPreferences = this.applicationRootPreferences.node(ARTIFACTS);
        this.repositoriesRootPreferences = this.applicationRootPreferences.node(REPOSITORIES);
        this.mavenPreferences = new MavenPreferences();
        try {
            for (String child : childrenNames = this.artifactsRootPreferences.childrenNames()) {
                Preferences artifactPreferences = this.artifactsRootPreferences.node(child);
                MavenArtifact mavenArtifact = new MavenArtifact(child);
                mavenArtifact.setPath(artifactPreferences.get(PATH, null));
                mavenArtifact.setDependencies(artifactPreferences.get("dependencies", null));
                mavenArtifact.setFilter(artifactPreferences.get("filter", null));
                PreferencesRecordArtifact recordArtifact = new PreferencesRecordArtifact(this.artifactsRootPreferences, mavenArtifact);
                this.mavenPreferences.addRecordArtifact(child, recordArtifact);
            }
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(PreferencesControllerBase.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.repositoryPreferences = new RepositoryPreferences();
        try {
            for (String child : childrenNames = this.repositoriesRootPreferences.childrenNames()) {
                Preferences rp = this.repositoriesRootPreferences.node(child);
                Repository repository = new Repository(rp.get("ID", null), rp.get("type", null), rp.get("URL", null), rp.get("User", null), rp.get("Password", null));
                PreferencesRecordRepository recordRepository = new PreferencesRecordRepository(this.artifactsRootPreferences, repository);
                this.repositoryPreferences.addRecordRepository(child, recordRepository);
            }
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(PreferencesControllerBase.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public PreferencesRecordGlobalBase getRecordGlobal() {
        return this.recordGlobal;
    }

    public MavenPreferences getMavenPreferences() {
        return this.mavenPreferences;
    }

    public PreferencesRecordArtifact getRecordArtifact(MavenArtifact mavenArtifact) {
        PreferencesRecordArtifact recordArtifact = this.mavenPreferences.getRecordArtifact(mavenArtifact.getCoordinates());
        if (recordArtifact == null) {
            recordArtifact = new PreferencesRecordArtifact(this.artifactsRootPreferences, mavenArtifact);
            this.mavenPreferences.addRecordArtifact(mavenArtifact.getCoordinates(), recordArtifact);
        }
        return recordArtifact;
    }

    public void removeArtifact(String coordinates) {
        if (coordinates != null && !coordinates.isEmpty() && this.mavenPreferences.getRecordArtifact(coordinates) != null) {
            Preferences node = this.artifactsRootPreferences.node(coordinates);
            try {
                node.removeNode();
                this.mavenPreferences.removeRecordArtifact(coordinates);
            }
            catch (BackingStoreException ex) {
                Logger.getLogger(PreferencesControllerBase.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public RepositoryPreferences getRepositoryPreferences() {
        return this.repositoryPreferences;
    }

    public PreferencesRecordRepository getRecordRepository(Repository repository) {
        PreferencesRecordRepository recordRepository = this.repositoryPreferences.getRecordRepository(repository.getId());
        if (recordRepository == null) {
            recordRepository = new PreferencesRecordRepository(this.repositoriesRootPreferences, repository);
            this.repositoryPreferences.addRecordRepository(repository.getId(), recordRepository);
        }
        return recordRepository;
    }

    public void removeRepository(String id) {
        if (id != null && !id.isEmpty() && this.repositoryPreferences.getRecordRepository(id) != null) {
            Preferences node = this.repositoriesRootPreferences.node(id);
            try {
                node.removeNode();
                this.repositoryPreferences.removeRecordRepository(id);
            }
            catch (BackingStoreException ex) {
                Logger.getLogger(PreferencesControllerBase.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

