/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.preferences;

import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.MavenArtifact;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class PreferencesRecordArtifact {
    private final Preferences artifactsRootPreferences;
    private Preferences artifactPreferences;
    private static final String GROUPID = "groupID";
    private static final String ARTIFACTID = "artifactId";
    private static final String VERSION = "version";
    public static final String DEPENDENCIES = "dependencies";
    public static final String FILTER = "filter";
    public static final String PATH = "path";
    private String groupId;
    private String artifactId;
    private String version;
    private final MavenArtifact mavenArtifact;

    public PreferencesRecordArtifact(Preferences artifactsRootPreferences, MavenArtifact mavenArtifact) {
        this.artifactsRootPreferences = artifactsRootPreferences;
        this.mavenArtifact = mavenArtifact;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getPath() {
        return this.mavenArtifact.getPath();
    }

    public MavenArtifact getMavenArtifact() {
        return this.mavenArtifact;
    }

    public void readFromJavaPreferences() {
        assert (this.artifactPreferences == null);
        try {
            String[] childrenNames;
            for (String child : childrenNames = this.artifactsRootPreferences.childrenNames()) {
                if (!child.equals(this.mavenArtifact.getCoordinates())) continue;
                this.artifactPreferences = this.artifactsRootPreferences.node(child);
            }
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(PreferencesRecordArtifact.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.artifactPreferences == null) {
            return;
        }
        this.setGroupId(this.artifactPreferences.get(GROUPID, null));
        this.setArtifactId(this.artifactPreferences.get(ARTIFACTID, null));
        this.setVersion(this.artifactPreferences.get(VERSION, null));
        this.mavenArtifact.setDependencies(this.artifactPreferences.get(DEPENDENCIES, null));
        this.mavenArtifact.setFilter(this.artifactPreferences.get(FILTER, null));
        this.mavenArtifact.setPath(this.artifactPreferences.get(PATH, null));
    }

    public void writeToJavaPreferences() {
        assert (this.artifactsRootPreferences != null);
        assert (this.mavenArtifact.getCoordinates() != null);
        if (this.artifactPreferences == null) {
            try {
                assert (!this.artifactsRootPreferences.nodeExists(this.mavenArtifact.getCoordinates()));
                this.artifactPreferences = this.artifactsRootPreferences.node(this.mavenArtifact.getCoordinates());
            }
            catch (BackingStoreException ex) {
                Logger.getLogger(PreferencesRecordArtifact.class.getName()).log(Level.SEVERE, null, ex);
                return;
            }
        }
        assert (this.artifactPreferences != null);
        String[] items = this.mavenArtifact.getCoordinates().split(":");
        this.artifactPreferences.put(GROUPID, items[0]);
        this.artifactPreferences.put(ARTIFACTID, items[1]);
        this.artifactPreferences.put(VERSION, items[2]);
        this.artifactPreferences.put(DEPENDENCIES, this.mavenArtifact.getDependencies());
        this.artifactPreferences.put(FILTER, this.mavenArtifact.getFilter());
        this.artifactPreferences.put(PATH, this.mavenArtifact.getPath());
    }
}

