/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.preferences;

import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.editor.panel.content.ContentPanelController;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import java.net.URL;
import java.util.prefs.Preferences;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;

public abstract class PreferencesRecordGlobalBase {
    public static final BackgroundImage DEFAULT_BACKGROUND_IMAGE = BackgroundImage.BACKGROUND_03;
    public static final Color DEFAULT_ALIGNMENT_GUIDES_COLOR = Color.RED;
    public static final Color DEFAULT_PARENT_RING_COLOR = Color.rgb((int)238, (int)168, (int)47);
    public static final EditorPlatform.Theme DEFAULT_THEME = EditorPlatform.DEFAULT_THEME;
    protected Preferences applicationRootPreferences;
    protected double rootContainerHeight;
    protected double rootContainerWidth;
    protected BackgroundImage backgroundImage = DEFAULT_BACKGROUND_IMAGE;
    protected Color alignmentGuidesColor = DEFAULT_ALIGNMENT_GUIDES_COLOR;
    protected Color parentRingColor = DEFAULT_PARENT_RING_COLOR;
    protected EditorPlatform.Theme theme = DEFAULT_THEME;

    public void setApplicationRootPreferences(Preferences applicationRootPreferences) {
        this.applicationRootPreferences = applicationRootPreferences;
    }

    public double getRootContainerHeight() {
        return this.rootContainerHeight;
    }

    public void setRootContainerHeight(double value) {
        this.rootContainerHeight = value;
    }

    public double getRootContainerWidth() {
        return this.rootContainerWidth;
    }

    public void setRootContainerWidth(double value) {
        this.rootContainerWidth = value;
    }

    public BackgroundImage getBackgroundImage() {
        return this.backgroundImage;
    }

    public Image getBackgroundImageImage() {
        return PreferencesRecordGlobalBase.getImage(this.backgroundImage);
    }

    public void setBackgroundImage(BackgroundImage value) {
        this.backgroundImage = value;
    }

    public Color getAlignmentGuidesColor() {
        return this.alignmentGuidesColor;
    }

    public void setAlignmentGuidesColor(Color value) {
        this.alignmentGuidesColor = value;
    }

    public Color getParentRingColor() {
        return this.parentRingColor;
    }

    public void setParentRingColor(Color value) {
        this.parentRingColor = value;
    }

    public EditorPlatform.Theme getTheme() {
        return this.theme;
    }

    public void setTheme(EditorPlatform.Theme theme) {
        this.theme = theme;
    }

    public void readFromJavaPreferences() {
        assert (this.applicationRootPreferences != null);
        double height = this.applicationRootPreferences.getDouble("ROOT_CONTAINER_HEIGHT", -1.0);
        this.setRootContainerHeight(height);
        double width = this.applicationRootPreferences.getDouble("ROOT_CONTAINER_WIDTH", -1.0);
        this.setRootContainerWidth(width);
        String image = this.applicationRootPreferences.get("BACKGROUND_IMAGE", DEFAULT_BACKGROUND_IMAGE.name());
        this.setBackgroundImage(BackgroundImage.valueOf(image));
        String agColor = this.applicationRootPreferences.get("ALIGNMENT_GUIDES_COLOR", DEFAULT_ALIGNMENT_GUIDES_COLOR.toString());
        this.setAlignmentGuidesColor(Color.valueOf((String)agColor));
        String prColor = this.applicationRootPreferences.get("PARENT_RING_COLOR", DEFAULT_PARENT_RING_COLOR.toString());
        this.setParentRingColor(Color.valueOf((String)prColor));
        String themeName = this.applicationRootPreferences.get("theme", DEFAULT_THEME.name());
        this.theme = EditorPlatform.Theme.valueOf(themeName);
    }

    public void writeToJavaPreferences(String key) {
        assert (this.applicationRootPreferences != null);
        assert (key != null);
        switch (key) {
            case "ROOT_CONTAINER_HEIGHT": {
                this.applicationRootPreferences.putDouble("ROOT_CONTAINER_HEIGHT", this.getRootContainerHeight());
                break;
            }
            case "ROOT_CONTAINER_WIDTH": {
                this.applicationRootPreferences.putDouble("ROOT_CONTAINER_WIDTH", this.getRootContainerWidth());
                break;
            }
            case "BACKGROUND_IMAGE": {
                this.applicationRootPreferences.put("BACKGROUND_IMAGE", this.backgroundImage.name());
                break;
            }
            case "ALIGNMENT_GUIDES_COLOR": {
                this.applicationRootPreferences.put("ALIGNMENT_GUIDES_COLOR", this.getAlignmentGuidesColor().toString());
                break;
            }
            case "PARENT_RING_COLOR": {
                this.applicationRootPreferences.put("PARENT_RING_COLOR", this.getParentRingColor().toString());
                break;
            }
            case "theme": {
                this.applicationRootPreferences.put("theme", this.getTheme().name());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private static Image getImage(BackgroundImage bgi) {
        URL url;
        switch (bgi.ordinal()) {
            case 0: {
                url = PreferencesRecordGlobalBase.class.getResource("Background-Blue-Grid.png");
                break;
            }
            case 1: {
                url = PreferencesRecordGlobalBase.class.getResource("Background-Neutral-Grid.png");
                break;
            }
            case 2: {
                url = ContentPanelController.getDefaultWorkspaceBackgroundURL();
                break;
            }
            default: {
                url = null;
                assert (false);
                break;
            }
        }
        assert (url != null);
        return new Image(url.toExternalForm());
    }

    public static enum BackgroundImage {
        BACKGROUND_01{

            public String toString() {
                return I18N.getString("prefs.background.value1");
            }
        }
        ,
        BACKGROUND_02{

            public String toString() {
                return I18N.getString("prefs.background.value2");
            }
        }
        ,
        BACKGROUND_03{

            public String toString() {
                return I18N.getString("prefs.background.value3");
            }
        };

    }
}

