/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.preferences;

import com.oracle.javafx.scenebuilder.kit.editor.panel.library.maven.repository.Repository;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class PreferencesRecordRepository {
    private final Preferences repositoriesRootPreferences;
    private Preferences repositoryPreferences;
    public static final String REPO_ID = "ID";
    public static final String REPO_TYPE = "type";
    public static final String REPO_URL = "URL";
    public static final String REPO_USER = "User";
    public static final String REPO_PASS = "Password";
    private final Repository repository;

    public PreferencesRecordRepository(Preferences artifactsRootPreferences, Repository repository) {
        this.repositoriesRootPreferences = artifactsRootPreferences;
        this.repository = repository;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void readFromJavaPreferences() {
        assert (this.repositoryPreferences == null);
        try {
            String[] childrenNames;
            for (String child : childrenNames = this.repositoriesRootPreferences.childrenNames()) {
                if (!child.equals(this.repository.getId())) continue;
                this.repositoryPreferences = this.repositoriesRootPreferences.node(child);
            }
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(PreferencesRecordRepository.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.repositoryPreferences == null) {
            return;
        }
        this.repository.setId(this.repositoryPreferences.get(REPO_ID, null));
        this.repository.setType(this.repositoryPreferences.get(REPO_TYPE, null));
        this.repository.setURL(this.repositoryPreferences.get(REPO_URL, null));
        this.repository.setUser(this.repositoryPreferences.get(REPO_USER, null));
        this.repository.setPassword(this.repositoryPreferences.get(REPO_PASS, null));
    }

    public void writeToJavaPreferences() {
        assert (this.repositoriesRootPreferences != null);
        assert (this.repository.getId() != null);
        if (this.repositoryPreferences == null) {
            try {
                assert (!this.repositoriesRootPreferences.nodeExists(this.repository.getId()));
                this.repositoryPreferences = this.repositoriesRootPreferences.node(this.repository.getId());
            }
            catch (BackingStoreException ex) {
                Logger.getLogger(PreferencesRecordRepository.class.getName()).log(Level.SEVERE, null, ex);
                return;
            }
        }
        assert (this.repositoryPreferences != null);
        this.repositoryPreferences.put(REPO_ID, this.repository.getId());
        this.repositoryPreferences.put(REPO_TYPE, this.repository.getType());
        this.repositoryPreferences.put(REPO_URL, this.repository.getURL());
        if (this.repository.getUser() != null) {
            this.repositoryPreferences.put(REPO_USER, this.repository.getUser());
        }
        if (this.repository.getPassword() != null) {
            this.repositoryPreferences.put(REPO_PASS, this.repository.getPassword());
        }
    }
}

