/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.preview;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.EditorPlatform;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractWindowController;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import com.oracle.javafx.scenebuilder.kit.util.Utils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Camera;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.MeshView;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Translate;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;

public final class PreviewWindowController
extends AbstractWindowController {
    private final EditorController editorController;
    private Timer timer = null;
    private final int WIDTH_WHEN_EMPTY = 320;
    private final int HEIGHT_WHEN_EMPTY = 200;
    private CameraType cameraType;
    private boolean autoResize3DContent = true;
    private static final String NID_PREVIEW_ROOT = "previewRoot";
    private EditorPlatform.Theme editorControllerTheme;
    private ObservableList<File> sceneStyleSheet;
    private EditorController.Size currentSize = EditorController.Size.SIZE_PREFERRED;
    private boolean sizeChangedFromMenu = false;
    private static final double TARGET_SIZE_3D = 500.0;
    private double decorationX = 0.0;
    private double decorationY = 0.0;
    private boolean isDirty = false;
    private final long IMMEDIATE = 0L;
    private final long DELAYED = 1000L;
    private final ChangeListener<Number> fxomDocumentRevisionListener = (observable, oldValue, newValue) -> this.requestUpdate(1000L);
    private final ChangeListener<Number> cssRevisionListener = (observable, oldValue, newValue) -> this.requestUpdate(0L);

    public PreviewWindowController(EditorController editorController, Stage owner) {
        super(owner);
        this.editorController = editorController;
        this.editorController.fxomDocumentProperty().addListener((ov, od, nd) -> {
            assert (editorController.getFxomDocument() == nd);
            if (od != null) {
                od.sceneGraphRevisionProperty().removeListener(this.fxomDocumentRevisionListener);
                od.cssRevisionProperty().removeListener(this.cssRevisionListener);
            }
            if (nd != null) {
                nd.sceneGraphRevisionProperty().addListener(this.fxomDocumentRevisionListener);
                nd.cssRevisionProperty().addListener(this.cssRevisionListener);
                this.requestUpdate(1000L);
            }
        });
        if (editorController.getFxomDocument() != null) {
            editorController.getFxomDocument().sceneGraphRevisionProperty().addListener(this.fxomDocumentRevisionListener);
            editorController.getFxomDocument().cssRevisionProperty().addListener(this.cssRevisionListener);
        }
        this.editorControllerTheme = editorController.getTheme();
        this.editorController.themeProperty().addListener((ov, t, t1) -> {
            if (t1 != null) {
                this.editorControllerTheme = t1;
                this.requestUpdate(1000L);
            }
        });
        this.sceneStyleSheet = editorController.getSceneStyleSheets();
        this.editorController.sceneStyleSheetProperty().addListener((ov, t, t1) -> {
            if (t1 != null) {
                this.sceneStyleSheet = t1;
                this.requestUpdate(1000L);
            }
        });
        this.editorController.resourcesProperty().addListener((ov, t, t1) -> this.requestUpdate(1000L));
        this.editorController.sampleDataEnabledProperty().addListener((ov, t, t1) -> this.requestUpdate(1000L));
    }

    @Override
    protected void makeRoot() {
        StackPane sp = new StackPane();
        sp.setPrefSize(320.0, 200.0);
        this.setRoot((Parent)sp);
        this.requestUpdate(0L);
    }

    @Override
    public void onCloseRequest(WindowEvent event) {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.getStage().close();
    }

    @Override
    protected void controllerDidCreateStage() {
        this.updateWindowSize();
        this.updateWindowTitle();
    }

    @Override
    public void openWindow() {
        super.openWindow();
        if (this.isDirty) {
            this.requestUpdate(0L);
            this.isDirty = false;
        }
    }

    public void openDialog() {
        FXOMDocument clone;
        FXOMDocument fxomDocument = this.editorController.getFxomDocument();
        assert (fxomDocument != null);
        try {
            clone = new FXOMDocument(fxomDocument.getFxmlText(false), fxomDocument.getLocation(), fxomDocument.getClassLoader(), fxomDocument.getResources(), FXOMDocument.FXOMDocumentSwitch.FOR_PREVIEW, FXOMDocument.FXOMDocumentSwitch.NORMALIZED);
            clone.setSampleDataEnabled(fxomDocument.isSampleDataEnabled());
        }
        catch (IOException ex) {
            throw new RuntimeException("Bug in PreviewWindowController::openDialog", ex);
        }
        Object sceneGraphRoot = clone.getSceneGraphRoot();
        assert (sceneGraphRoot instanceof DialogPane);
        DialogPane dialogPane = (DialogPane)sceneGraphRoot;
        Dialog dialog = new Dialog();
        dialog.setDialogPane(dialogPane);
        dialog.initModality(Modality.NONE);
        if (dialogPane.getButtonTypes().isEmpty()) {
            dialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CLOSE});
        }
        dialog.show();
    }

    @Override
    public void closeWindow() {
        super.closeWindow();
        this.isDirty = true;
    }

    @Override
    protected void toolStylesheetDidChange(String oldStylesheet) {
    }

    private void requestUpdate(long delay) {
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                Platform.runLater(() -> {
                    FXOMDocument fxomDocument = PreviewWindowController.this.editorController.getFxomDocument();
                    ArrayList<String> themeStyleSheetsList = null;
                    if (fxomDocument != null) {
                        FXOMDocument clone;
                        try {
                            clone = new FXOMDocument(fxomDocument.getFxmlText(false), fxomDocument.getLocation(), fxomDocument.getClassLoader(), fxomDocument.getResources(), FXOMDocument.FXOMDocumentSwitch.FOR_PREVIEW);
                            clone.setSampleDataEnabled(fxomDocument.isSampleDataEnabled());
                        }
                        catch (IOException ex) {
                            throw new RuntimeException("Bug in PreviewWindowController::requestUpdate", ex);
                        }
                        Object sceneGraphRoot = clone.getDisplayNodeOrSceneGraphRoot();
                        themeStyleSheetsList = new ArrayList<String>(EditorPlatform.getStylesheetsForTheme(PreviewWindowController.this.editorController.getTheme()));
                        PreviewWindowController.this.editorControllerTheme.getStylesheetURLs().stream().filter(s -> !EditorPlatform.isPlatformThemeStylesheetURL(s)).forEach(themeStyleSheetsList::add);
                        if (sceneGraphRoot instanceof Parent) {
                            ((Parent)sceneGraphRoot).setId(PreviewWindowController.NID_PREVIEW_ROOT);
                            assert (((Parent)sceneGraphRoot).getScene() == null);
                            PreviewWindowController.this.setRoot((Parent)PreviewWindowController.this.updateAutoResizeTransform((Node)((Parent)sceneGraphRoot)));
                            ArrayList<String> newStyleSheets1 = new ArrayList<String>();
                            PreviewWindowController.this.computeStyleSheets(newStyleSheets1, sceneGraphRoot, clone.getDisplayStylesheets());
                            ((Parent)sceneGraphRoot).getStylesheets().removeAll((Object[])new String[0]);
                            ((Parent)sceneGraphRoot).getStylesheets().addAll(newStyleSheets1);
                        } else if (sceneGraphRoot instanceof Node) {
                            StackPane sp1 = new StackPane();
                            sp1.setId(PreviewWindowController.NID_PREVIEW_ROOT);
                            ArrayList<String> newStyleSheets2 = new ArrayList<String>();
                            PreviewWindowController.this.computeStyleSheets(newStyleSheets2, sceneGraphRoot, clone.getDisplayStylesheets());
                            sp1.getStylesheets().addAll(newStyleSheets2);
                            ((Node)sceneGraphRoot).applyCss();
                            sp1.getChildren().add((Object)PreviewWindowController.this.updateAutoResizeTransform((Node)sceneGraphRoot));
                            PreviewWindowController.this.setRoot((Parent)sp1);
                        } else {
                            PreviewWindowController.this.setCameraType(CameraType.PARALLEL);
                            PreviewWindowController.this.sizeChangedFromMenu = false;
                            StackPane sp2 = new StackPane(new Node[]{new Label(I18N.getString("preview.not.node"))});
                            sp2.setId(PreviewWindowController.NID_PREVIEW_ROOT);
                            sp2.setPrefSize(320.0, 200.0);
                            PreviewWindowController.this.setRoot((Parent)sp2);
                        }
                    } else {
                        PreviewWindowController.this.setCameraType(CameraType.PARALLEL);
                        PreviewWindowController.this.sizeChangedFromMenu = false;
                        StackPane sp3 = new StackPane(new Node[]{new Label(I18N.getString("preview.no.document"))});
                        sp3.setId(PreviewWindowController.NID_PREVIEW_ROOT);
                        sp3.setPrefSize(320.0, 200.0);
                        PreviewWindowController.this.setRoot((Parent)sp3);
                    }
                    PreviewWindowController.this.getScene().setRoot(PreviewWindowController.this.getRoot());
                    if (themeStyleSheetsList != null && !themeStyleSheetsList.isEmpty()) {
                        PreviewWindowController.this.getScene().setUserAgentStylesheet((String)themeStyleSheetsList.getFirst());
                        ObservableList newStylesheets = FXCollections.observableArrayList(themeStyleSheetsList);
                        PreviewWindowController.this.getScene().getStylesheets().clear();
                        PreviewWindowController.this.getScene().getStylesheets().addAll((Collection)newStylesheets);
                    }
                    PreviewWindowController.this.updateWindowSize();
                    PreviewWindowController.this.updateWindowTitle();
                });
            }
        };
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer(true);
        this.timer.schedule(timerTask, delay);
    }

    public boolean userResizedPreviewWindow() {
        boolean res = false;
        double sceneHeight = this.getScene().getHeight();
        double sceneWidth = this.getScene().getWidth();
        if (sceneHeight > 0.0 && sceneWidth > 0.0) {
            double prefHeight = this.getRoot().prefHeight(-1.0);
            double prefWidth = this.getRoot().prefWidth(-1.0);
            if (!MathUtils.equals(prefHeight, sceneHeight) && !MathUtils.equals(sceneHeight, 200.0) && !MathUtils.equals(sceneHeight, this.getHeightFromSize(this.getSize())) || !MathUtils.equals(prefWidth, sceneWidth) && !MathUtils.equals(sceneWidth, 320.0) && !MathUtils.equals(sceneWidth, this.getWidthFromSize(this.getSize()))) {
                res = true;
            }
        }
        return res;
    }

    private void updateWindowSize() {
        FXOMDocument fxomDocument = this.editorController.getFxomDocument();
        if (fxomDocument != null) {
            if (this.sizeChangedFromMenu) {
                this.sizeChangedFromMenu = false;
                this.getStage().setWidth(this.getWidthFromSize(this.getSize()) + this.decorationX);
                this.getStage().setHeight(this.getHeightFromSize(this.getSize()) + this.decorationY);
            } else if (!this.userResizedPreviewWindow()) {
                if (fxomDocument.getSceneGraphRoot() instanceof MeshView) {
                    this.getStage().setWidth(500.0);
                    this.getStage().setHeight(500.0);
                } else {
                    this.getStage().sizeToScene();
                }
                this.decorationX = this.getStage().getWidth() - this.getRoot().prefWidth(-1.0);
                this.decorationY = this.getStage().getHeight() - this.getRoot().prefHeight(-1.0);
            }
        } else {
            this.getStage().setWidth(320.0);
            this.getStage().setHeight(200.0);
        }
    }

    private void updateWindowTitle() {
        FXOMDocument fxomDocument = this.editorController.getFxomDocument();
        this.getStage().setTitle(Utils.makeTitle(fxomDocument));
    }

    public final void setCameraType(CameraType ct) {
        this.cameraType = ct;
        this.updateCamera();
    }

    void updateCamera() {
        if (this.getScene() != null) {
            if (this.cameraType == CameraType.PERSPECTIVE) {
                this.getScene().setCamera((Camera)new PerspectiveCamera(false));
            } else {
                this.getScene().setCamera(null);
            }
        }
    }

    public boolean isAutoResize3DContent() {
        return this.autoResize3DContent;
    }

    public void setAutoResize3DContent(boolean autoResize3DContent) {
        this.autoResize3DContent = autoResize3DContent;
    }

    Node updateAutoResizeTransform(Node whatever) {
        Node res = whatever;
        assert (this.editorController.getFxomDocument() != null);
        if (this.editorController.is3D() && this.autoResize3DContent) {
            res.getTransforms().clear();
            Bounds rootBounds = res.getLayoutBounds();
            double scaleX = 500.0 / rootBounds.getWidth();
            double scaleY = 500.0 / rootBounds.getHeight();
            double scaleZ = 500.0 / rootBounds.getDepth();
            double scale = Math.min(scaleX, Math.min(scaleY, scaleZ));
            double tX = -rootBounds.getMinX();
            double tY = -rootBounds.getMinY();
            double tZ = -rootBounds.getMinZ();
            res.getTransforms().add((Object)new Scale(scale, scale, scale));
            res.getTransforms().add((Object)new Translate(tX, tY, tZ));
            this.setCameraType(CameraType.PERSPECTIVE);
        } else {
            this.setCameraType(CameraType.PARALLEL);
        }
        return res;
    }

    private double getWidthFromSize(EditorController.Size size) {
        double res = 320.0;
        switch (size) {
            case SIZE_335x600: {
                res = 335.0;
                break;
            }
            case SIZE_900x600: {
                res = 900.0;
                break;
            }
            case SIZE_1280x800: {
                res = 1280.0;
                break;
            }
            case SIZE_1920x1080: {
                res = 1920.0;
                break;
            }
            case SIZE_320x240: {
                res = 320.0;
                break;
            }
            case SIZE_640x480: {
                res = 640.0;
                break;
            }
            case SIZE_PREFERRED: {
                res = this.getRoot().prefWidth(-1.0);
                break;
            }
        }
        return res;
    }

    private double getHeightFromSize(EditorController.Size size) {
        double res = 200.0;
        switch (size) {
            case SIZE_335x600: {
                res = 600.0;
                break;
            }
            case SIZE_900x600: {
                res = 600.0;
                break;
            }
            case SIZE_1280x800: {
                res = 800.0;
                break;
            }
            case SIZE_1920x1080: {
                res = 1080.0;
                break;
            }
            case SIZE_320x240: {
                res = 240.0;
                break;
            }
            case SIZE_640x480: {
                res = 480.0;
                break;
            }
            case SIZE_PREFERRED: {
                res = this.getRoot().prefHeight(-1.0);
                break;
            }
        }
        return res;
    }

    public EditorController.Size getSize() {
        return this.currentSize;
    }

    public void setSize(EditorController.Size size) {
        this.currentSize = size;
        this.sizeChangedFromMenu = true;
        this.requestUpdate(0L);
    }

    private void computeStyleSheets(List<String> newStyleSheets, Object sceneGraphRoot, List<String> displayStylesheets) {
        if (sceneGraphRoot instanceof Parent) {
            ObservableList currentStyleSheets = ((Parent)sceneGraphRoot).getStylesheets();
            for (String stylesheet : currentStyleSheets) {
                newStyleSheets.add(stylesheet);
            }
        }
        newStyleSheets.addAll(displayStylesheets);
        if (this.sceneStyleSheet != null) {
            for (File f : this.sceneStyleSheet) {
                String urlString = "";
                try {
                    urlString = f.toURI().toURL().toString();
                }
                catch (MalformedURLException ex) {
                    throw new RuntimeException("Bug in PreviewWindowController", ex);
                }
                newStyleSheets.add(urlString);
            }
        }
    }

    public boolean sizeDoesFit(EditorController.Size size) {
        boolean res = false;
        if (this.getStage() != null) {
            Rectangle2D frame = this.getBiggestViewableRectangle();
            if (this.getWidthFromSize(size) <= frame.getWidth() - this.decorationX && this.getHeightFromSize(size) <= frame.getHeight() - this.decorationY) {
                res = true;
            }
        }
        return res;
    }

    public static enum CameraType {
        PARALLEL,
        PERSPECTIVE;

    }
}

