/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.skeleton;

import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.skeleton.SkeletonContext;
import com.oracle.javafx.scenebuilder.kit.skeleton.SkeletonConverter;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.util.Map;
import java.util.ResourceBundle;

abstract class AbstractSkeletonCreator
implements SkeletonConverter {
    static final String NL = System.lineSeparator();
    static final String INDENT = "    ";
    static final String FXML_ANNOTATION = "@FXML";

    AbstractSkeletonCreator() {
    }

    @Override
    public String createFrom(SkeletonContext context) {
        StringBuilder sb = new StringBuilder();
        this.appendHeaderComment(context, sb);
        this.appendPackage(context, sb);
        this.appendImports(context, sb);
        this.appendClass(context, sb);
        return sb.toString();
    }

    void appendHeaderComment(SkeletonContext context, StringBuilder sb) {
        if (!context.getSettings().isWithComments()) {
            return;
        }
        String title = I18N.getString("skeleton.window.title", context.getDocumentName());
        sb.append("/**").append(NL);
        sb.append(" * ").append(title).append(NL);
        sb.append(" */").append(NL);
        sb.append(NL);
    }

    abstract void appendPackage(SkeletonContext var1, StringBuilder var2);

    abstract void appendImports(SkeletonContext var1, StringBuilder var2);

    void appendClass(SkeletonContext context, StringBuilder sb) {
        sb.append(NL);
        this.appendClassPart(context, sb);
        sb.append(" {").append(NL).append(NL);
        this.appendFields(context, sb);
        this.appendMethods(context, sb);
        sb.append("}").append(NL);
    }

    abstract void appendClassPart(SkeletonContext var1, StringBuilder var2);

    void appendFields(SkeletonContext context, StringBuilder sb) {
        this.appendFieldsResourcesAndLocation(context, sb);
        this.appendFieldsWithFxId(context, sb);
    }

    void appendFieldsResourcesAndLocation(SkeletonContext context, StringBuilder sb) {
        if (!context.getSettings().isFull()) {
            return;
        }
        sb.append(INDENT).append(FXML_ANNOTATION);
        if (context.getSettings().isWithComments()) {
            sb.append(" // ResourceBundle that was given to the FXMLLoader");
        }
        sb.append(NL);
        sb.append(INDENT);
        this.appendField(ResourceBundle.class, "resources", sb);
        sb.append(NL).append(NL);
        sb.append(INDENT).append(FXML_ANNOTATION);
        if (context.getSettings().isWithComments()) {
            sb.append(" // URL location of the FXML file that was given to the FXMLLoader");
        }
        sb.append(NL);
        sb.append(INDENT);
        this.appendField(URL.class, "location", sb);
        sb.append(NL).append(NL);
    }

    void appendFieldsWithFxId(SkeletonContext context, StringBuilder sb) {
        for (Map.Entry<String, Class<?>> variable : context.getVariables().entrySet()) {
            sb.append(INDENT).append(FXML_ANNOTATION);
            if (context.getSettings().isWithComments()) {
                sb.append(" // fx:id=\"").append(variable.getKey()).append("\"");
            }
            sb.append(NL);
            sb.append(INDENT);
            this.appendField(variable.getValue(), variable.getKey(), sb);
            if (context.getSettings().isWithComments()) {
                sb.append(" // Value injected by FXMLLoader");
            }
            sb.append(NL).append(NL);
        }
    }

    abstract void appendField(Class<?> var1, String var2, StringBuilder var3);

    void appendFieldParameters(StringBuilder sb, Class<?> fieldClazz) {
        TypeVariable<Class<?>>[] parameters = fieldClazz.getTypeParameters();
        if (parameters.length > 0) {
            sb.append("<");
            String sep = "";
            for (TypeVariable<Class<?>> ignored : parameters) {
                sb.append(sep);
                this.appendFieldParameterType(sb);
                sep = ", ";
            }
            sb.append(">");
        }
    }

    abstract void appendFieldParameterType(StringBuilder var1);

    void appendMethods(SkeletonContext context, StringBuilder sb) {
        this.appendEventHandlers(context, sb);
        this.appendInitialize(context, sb);
    }

    void appendEventHandlers(SkeletonContext context, StringBuilder sb) {
        for (Map.Entry<String, String> entry : context.getEventHandlers().entrySet()) {
            String methodName = entry.getKey();
            String eventClassName = entry.getValue();
            String methodNamePured = methodName.replace("#", "");
            sb.append(INDENT).append(FXML_ANNOTATION).append(NL).append(INDENT);
            this.appendEventHandler(methodNamePured, eventClassName, sb);
            sb.append(NL).append(NL);
        }
    }

    abstract void appendEventHandler(String var1, String var2, StringBuilder var3);

    void appendInitialize(SkeletonContext context, StringBuilder sb) {
        if (!context.getSettings().isFull()) {
            return;
        }
        sb.append(INDENT).append(FXML_ANNOTATION);
        if (context.getSettings().isWithComments()) {
            sb.append(" // This method is called by the FXMLLoader when initialization is complete");
        }
        sb.append(NL);
        sb.append(INDENT);
        this.appendInitializeMethodPart(sb);
        sb.append(" {").append(NL);
        this.appendAssertions(context, sb);
        sb.append(NL);
        sb.append(INDENT);
        sb.append("}").append(NL).append(NL);
    }

    abstract void appendInitializeMethodPart(StringBuilder var1);

    abstract void appendAssertions(SkeletonContext var1, StringBuilder var2);
}

