/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.skeleton;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.skeleton.SkeletonContext;
import com.oracle.javafx.scenebuilder.kit.skeleton.SkeletonCreator;
import com.oracle.javafx.scenebuilder.kit.skeleton.SkeletonSettings;
import com.oracle.javafx.scenebuilder.kit.util.eventnames.FindEventNamesUtil;
import java.net.URL;
import java.util.ResourceBundle;

class SkeletonBuffer {
    private final FXOMDocument document;
    private final String documentName;
    private final SkeletonSettings settings = new SkeletonSettings();
    private final SkeletonCreator skeletonCreator = new SkeletonCreator();

    SkeletonBuffer(FXOMDocument document, String documentName) {
        assert (document != null);
        this.document = document;
        this.documentName = documentName;
    }

    void setLanguage(SkeletonSettings.LANGUAGE language) {
        this.settings.setLanguage(language);
    }

    void setTextType(SkeletonSettings.TEXT_TYPE type) {
        this.settings.setTextType(type);
    }

    void setFormat(SkeletonSettings.FORMAT_TYPE format) {
        this.settings.setFormat(format);
    }

    private boolean isFull() {
        return this.settings.isFull();
    }

    public String toString() {
        if (this.document.getFxomRoot() == null) {
            return I18N.getString("skeleton.empty");
        }
        SkeletonContext.Builder builder = SkeletonContext.builder().withFxController(this.document.getFxomRoot().getFxController()).withDocumentName(this.documentName).withSettings(this.settings);
        this.construct(builder);
        return this.skeletonCreator.createFrom(builder.build());
    }

    private void construct(SkeletonContext.Builder builder) {
        this.constructFxIds(builder);
        this.constructEventHandlers(builder);
        this.constructAdditionalImports(builder);
    }

    private void constructFxIds(SkeletonContext.Builder builder) {
        for (FXOMObject value : this.document.collectFxIds().values()) {
            builder.addFxId(value);
        }
    }

    private void constructEventHandlers(SkeletonContext.Builder builder) {
        FindEventNamesUtil.initializeEventsMap();
        for (FXOMPropertyT eventHandler : this.document.getFxomRoot().collectEventHandlers()) {
            builder.addEventHandler(eventHandler);
        }
    }

    private void constructAdditionalImports(SkeletonContext.Builder builder) {
        if (this.isFull()) {
            builder.addImportsFor(URL.class, ResourceBundle.class);
        }
    }
}

