/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.skeleton;

import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;
import com.oracle.javafx.scenebuilder.kit.skeleton.SkeletonSettings;
import com.oracle.javafx.scenebuilder.kit.util.eventnames.FindEventNamesUtil;
import com.oracle.javafx.scenebuilder.kit.util.eventnames.ImportBuilder;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javafx.fxml.FXML;

public class SkeletonContext {
    private final String fxController;
    private final String documentName;
    private final SkeletonSettings settings;
    private final SortedSet<String> imports;
    private final SortedMap<String, Class<?>> variables;
    private final SortedMap<String, String> eventHandlers;
    private final SortedSet<String> assertions;

    private SkeletonContext(String fxController, String documentName, SkeletonSettings settings, SortedSet<String> imports, SortedMap<String, Class<?>> variables, SortedMap<String, String> eventHandlers, SortedSet<String> assertions) {
        this.fxController = fxController;
        this.documentName = documentName;
        this.settings = Objects.requireNonNull(settings);
        this.imports = Collections.unmodifiableSortedSet(imports);
        this.variables = Collections.unmodifiableSortedMap(variables);
        this.eventHandlers = Collections.unmodifiableSortedMap(eventHandlers);
        this.assertions = Collections.unmodifiableSortedSet(assertions);
    }

    static Builder builder() {
        return new Builder();
    }

    String getFxController() {
        return this.fxController;
    }

    String getDocumentName() {
        return this.documentName;
    }

    SkeletonSettings getSettings() {
        return this.settings;
    }

    Set<String> getImports() {
        return this.imports;
    }

    Map<String, Class<?>> getVariables() {
        return this.variables;
    }

    Map<String, String> getEventHandlers() {
        return this.eventHandlers;
    }

    Set<String> getAssertions() {
        return this.assertions;
    }

    static class Builder {
        private String fxController;
        private String documentName;
        private SkeletonSettings settings;
        private final SortedSet<String> imports = new TreeSet<String>();
        private final SortedMap<String, Class<?>> variables = new TreeMap();
        private final SortedMap<String, String> eventHandlers = new TreeMap<String, String>();
        private final SortedSet<String> assertions = new TreeSet<String>();

        Builder() {
        }

        Builder withFxController(String fxController) {
            this.fxController = fxController;
            return this;
        }

        Builder withDocumentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        Builder withSettings(SkeletonSettings settings) {
            this.settings = settings;
            return this;
        }

        public void addFxId(FXOMObject value) {
            String fxId = value.getFxId();
            Class<?> type = value.getSceneGraphObject().getClass();
            this.addImportsFor(FXML.class, type);
            this.variables.put(fxId, type);
            this.assertions.add(fxId);
        }

        public void addEventHandler(FXOMPropertyT eventHandler) {
            String eventName = FindEventNamesUtil.findEventName(eventHandler.getName().getName());
            this.eventHandlers.put(eventHandler.getValue(), eventName);
            this.addImportsForEvents(eventName);
        }

        private void addImportsForEvents(String eventName) {
            if ("ActionEvent".equals(eventName)) {
                ImportBuilder.add("import ".concat("javafx.event."), eventName);
            } else {
                ImportBuilder.add("import ".concat("javafx.scene.input."), eventName);
            }
            this.buildAndCollectImports();
        }

        void addImportsFor(Class<?> ... classes) {
            for (Class<?> c : classes) {
                ImportBuilder.add("import ", c.getName().replace("$", "."));
                this.buildAndCollectImports();
            }
            ImportBuilder.add("import ", "javafx.fxml.FXML");
            this.buildAndCollectImports();
        }

        private void buildAndCollectImports() {
            this.imports.addAll(ImportBuilder.build());
            ImportBuilder.reset();
        }

        SkeletonContext build() {
            return new SkeletonContext(this.fxController, this.documentName, this.settings, this.imports, this.variables, this.eventHandlers, this.assertions);
        }
    }
}

