/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.skeleton;

import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.skeleton.SkeletonContext;
import com.oracle.javafx.scenebuilder.kit.skeleton.SkeletonConverter;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SkeletonCreatorJRuby
implements SkeletonConverter {
    static final String NL = System.lineSeparator();
    static final String INDENT = "    ";
    static Pattern importExtractor = Pattern.compile("import (([^.]+)\\..*)");

    SkeletonCreatorJRuby() {
    }

    @Override
    public String createFrom(SkeletonContext context) {
        StringBuilder sb = new StringBuilder();
        this.appendHeaderComment(context, sb);
        this.appendClass(context, sb);
        return sb.toString();
    }

    public String createApplicationFrom(SkeletonContext context) {
        return "require 'jrubyfx'\n\n" + this.createFrom(context) + "\nfxml_root File.dirname(__FILE__) # or wherever you save the fxml file to\n\nclass " + this.makeClassName(context) + "Application < JRubyFX::Application\n  def start(stage)\n    " + this.makeClassName(context) + ".load_into(stage)\n    #stage.title = \"" + this.makeClassName(context) + "\"\n    stage.show\n  end\n  launch\nend\n";
    }

    void appendImports(SkeletonContext context, StringBuilder sb) {
        boolean output = false;
        for (String importStatement : context.getImports()) {
            Matcher matcher = importExtractor.matcher(importStatement);
            matcher.matches();
            String rootName = matcher.group(2);
            if (rootName.equals("javafx")) continue;
            sb.append(INDENT).append("# java_import '").append(matcher.group(1)).append("'").append(NL);
            output = true;
        }
        if (output) {
            sb.append(NL);
        }
    }

    void appendHeaderComment(SkeletonContext context, StringBuilder sb) {
        if (!context.getSettings().isWithComments()) {
            return;
        }
        String title = I18N.getString("skeleton.window.title", context.getDocumentName());
        sb.append("# ").append(title).append(NL);
    }

    void appendClass(SkeletonContext context, StringBuilder sb) {
        Object documentName;
        String controllerClassName = this.makeClassName(context);
        sb.append("class ").append(controllerClassName);
        sb.append(NL);
        sb.append(INDENT).append("include JRubyFX::Controller").append(NL).append(NL);
        this.appendImports(context, sb);
        if (context.getSettings().isWithComments()) {
            sb.append(INDENT).append("# Marks this class as being a controller for the given fxml document").append(NL);
            sb.append(INDENT).append("# This creates @instance_variables for all fx:id").append(NL);
        }
        if (!((String)(documentName = context.getDocumentName())).contains(".fxml")) {
            documentName = (String)documentName + ".fxml";
        }
        sb.append(INDENT).append("fxml '").append((String)documentName).append("'").append(NL).append(NL);
        if (context.getSettings().isWithComments()) {
            sb.append(INDENT).append("# These @instance_variables will be injected by FXMLLoader & JRubyFX").append(NL);
        }
        this.appendFieldsWithFxId(context, sb);
        this.appendFieldsResourcesAndLocation(context, sb);
        this.appendInitialize(context, sb);
        this.appendEventHandlers(context, sb);
        sb.append("end").append(NL);
    }

    private String makeClassName(SkeletonContext context) {
        String controllerClassName = "PleaseProvideControllerClassName";
        if (this.hasController(context)) {
            controllerClassName = this.getControllerClassName(context);
        }
        return controllerClassName;
    }

    private boolean hasController(SkeletonContext context) {
        return context.getFxController() != null && !context.getFxController().isEmpty();
    }

    private String getControllerClassName(SkeletonContext context) {
        String simpleName = context.getFxController().replace("$", ".");
        int dot = simpleName.lastIndexOf(46);
        if (dot > -1) {
            simpleName = simpleName.substring(dot + 1);
        }
        return simpleName;
    }

    void appendFieldParameters(StringBuilder sb, Class<?> fieldClazz) {
        TypeVariable<Class<?>>[] parameters = fieldClazz.getTypeParameters();
        if (parameters.length > 0) {
            sb.append("<");
            String sep = "";
            for (TypeVariable<Class<?>> ignored : parameters) {
                sb.append(sep);
                sb.append("?");
                sep = ", ";
            }
            sb.append(">");
        }
    }

    void appendFieldsResourcesAndLocation(SkeletonContext context, StringBuilder sb) {
        if (!context.getSettings().isFull()) {
            return;
        }
        if (context.getSettings().isWithComments()) {
            sb.append(INDENT).append("# ResourceBundle that was given to the FXMLLoader. Access as self.resources, or @resources if instance_variable is true").append(NL);
        }
        sb.append(INDENT);
        sb.append("java_field '@javafx.fxml.FXML java.util.ResourceBundle resources', instance_variable: true");
        if (context.getSettings().isWithComments()) {
            sb.append(NL).append(NL).append(INDENT).append("# URL location of the FXML file that was given to the FXMLLoader. Access as self.location, or @location if instance_variable is true");
        }
        sb.append(NL).append(INDENT);
        sb.append("java_field '@javafx.fxml.FXML java.net.URL location', instance_variable: true");
        sb.append(NL).append(NL);
    }

    void appendFieldsWithFxId(SkeletonContext context, StringBuilder sb) {
        for (Map.Entry<String, Class<?>> variable : context.getVariables().entrySet()) {
            sb.append(INDENT).append("# @").append(variable.getKey()).append(": \t").append(variable.getValue().getSimpleName());
            this.appendFieldParameters(sb, variable.getValue());
            sb.append(NL);
        }
        sb.append(NL);
    }

    void appendInitialize(SkeletonContext context, StringBuilder sb) {
        if (!context.getSettings().isFull()) {
            return;
        }
        if (context.getSettings().isWithComments()) {
            sb.append(INDENT).append("# Called by JRubyFX after FXML loading is complete. Different from Java, same as normal Ruby");
            sb.append(NL);
        }
        sb.append(INDENT);
        sb.append("def initialize()");
        sb.append(NL);
        this.appendAssertions(context, sb);
        sb.append(NL);
        sb.append(INDENT);
        sb.append("end").append(NL).append(NL);
    }

    void appendEventHandlers(SkeletonContext context, StringBuilder sb) {
        for (Map.Entry<String, String> entry : context.getEventHandlers().entrySet()) {
            String methodName = entry.getKey();
            String eventClassName = entry.getValue();
            String methodNamePured = methodName.replace("#", "");
            sb.append(INDENT);
            this.appendEventHandler(methodNamePured, eventClassName, sb);
            sb.append(NL).append(NL);
        }
    }

    void appendEventHandler(String methodName, String eventClassName, StringBuilder sb) {
        sb.append("def ");
        sb.append(methodName);
        sb.append("(").append("event) # event: ").append(eventClassName).append(NL).append(NL);
        sb.append(INDENT).append("end");
    }

    void appendAssertions(SkeletonContext context, StringBuilder sb) {
        for (String assertion : context.getAssertions()) {
            sb.append(INDENT).append(INDENT).append("raise 'fx:id=\"").append(assertion).append("\" was not injected: check your FXML file ").append("\"").append(context.getDocumentName()).append("\".' if ").append("@").append(assertion).append(".nil?").append(NL);
        }
    }
}

