/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.skeleton;

import com.oracle.javafx.scenebuilder.kit.skeleton.AbstractSkeletonCreator;
import com.oracle.javafx.scenebuilder.kit.skeleton.SkeletonContext;

public class SkeletonCreatorJava
extends AbstractSkeletonCreator {
    SkeletonCreatorJava() {
    }

    @Override
    void appendPackage(SkeletonContext context, StringBuilder sb) {
        String controller = context.getFxController();
        if (controller != null && controller.contains(".") && !controller.contains("$")) {
            sb.append("package ");
            sb.append(controller, 0, controller.lastIndexOf(46));
            sb.append(";").append(NL).append(NL);
        }
    }

    @Override
    void appendImports(SkeletonContext context, StringBuilder sb) {
        for (String importStatement : context.getImports()) {
            sb.append(importStatement).append(";").append(NL);
        }
    }

    @Override
    void appendClassPart(SkeletonContext context, StringBuilder sb) {
        sb.append("public ");
        if (this.hasNestedController(context)) {
            sb.append("static ");
        }
        sb.append("class ");
        if (this.hasController(context)) {
            String controllerClassName = this.getControllerClassName(context);
            sb.append(controllerClassName);
        } else {
            sb.append("PleaseProvideControllerClassName");
        }
    }

    private boolean hasController(SkeletonContext context) {
        return context.getFxController() != null && !context.getFxController().isEmpty();
    }

    private boolean hasNestedController(SkeletonContext context) {
        return this.hasController(context) && context.getFxController().contains("$");
    }

    private String getControllerClassName(SkeletonContext context) {
        String simpleName = context.getFxController().replace("$", ".");
        int dot = simpleName.lastIndexOf(46);
        if (dot > -1) {
            simpleName = simpleName.substring(dot + 1);
        }
        return simpleName;
    }

    @Override
    void appendField(Class<?> fieldClass, String fieldName, StringBuilder sb) {
        sb.append("private ").append(fieldClass.getSimpleName());
        this.appendFieldParameters(sb, fieldClass);
        sb.append(" ").append(fieldName).append(";");
    }

    @Override
    void appendFieldParameterType(StringBuilder sb) {
        sb.append("?");
    }

    @Override
    void appendEventHandler(String methodName, String eventClassName, StringBuilder sb) {
        sb.append("void ");
        sb.append(methodName);
        sb.append("(").append(eventClassName).append(" event) {").append(NL).append(NL);
        sb.append("    ").append("}");
    }

    @Override
    void appendInitializeMethodPart(StringBuilder sb) {
        sb.append("void initialize()");
    }

    @Override
    void appendAssertions(SkeletonContext context, StringBuilder sb) {
        for (String assertion : context.getAssertions()) {
            sb.append("    ").append("    ").append("assert ").append(assertion).append(" != null : ").append("\"fx:id=\\\"").append(assertion).append("\\\" was not injected: check your FXML file ").append("'").append(context.getDocumentName()).append("'.\";").append(NL);
        }
    }
}

