/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.skeleton;

import com.oracle.javafx.scenebuilder.kit.skeleton.AbstractSkeletonCreator;
import com.oracle.javafx.scenebuilder.kit.skeleton.SkeletonContext;

public class SkeletonCreatorKotlin
extends AbstractSkeletonCreator {
    SkeletonCreatorKotlin() {
    }

    @Override
    void appendPackage(SkeletonContext context, StringBuilder sb) {
        String controller = context.getFxController();
        if (controller != null && controller.contains(".") && !controller.contains("$")) {
            sb.append("package ");
            sb.append(controller, 0, controller.lastIndexOf(46));
            sb.append(NL).append(NL);
        }
    }

    @Override
    void appendImports(SkeletonContext context, StringBuilder sb) {
        for (String importStatement : context.getImports()) {
            sb.append(importStatement).append(NL);
        }
    }

    @Override
    void appendClassPart(SkeletonContext context, StringBuilder sb) {
        sb.append("class ");
        if (this.hasController(context)) {
            String controllerClassName = this.getControllerClassName(context);
            sb.append(controllerClassName);
        } else {
            sb.append("PleaseProvideControllerClassName");
        }
    }

    private boolean hasController(SkeletonContext context) {
        return context.getFxController() != null && !context.getFxController().isEmpty();
    }

    private String getControllerClassName(SkeletonContext context) {
        String simpleName = context.getFxController().replace("$", ".");
        int dot = simpleName.lastIndexOf(46);
        if (dot > -1) {
            simpleName = simpleName.substring(dot + 1);
        }
        return simpleName;
    }

    @Override
    void appendField(Class<?> fieldClass, String fieldName, StringBuilder sb) {
        sb.append("private lateinit var ").append(fieldName).append(": ").append(fieldClass.getSimpleName());
        this.appendFieldParameters(sb, fieldClass);
    }

    @Override
    void appendFieldParameterType(StringBuilder sb) {
        sb.append("Any");
    }

    @Override
    void appendEventHandler(String methodName, String eventClassName, StringBuilder sb) {
        sb.append("fun ");
        sb.append(methodName);
        sb.append("(event: ").append(eventClassName).append(") {").append(NL).append(NL);
        sb.append("    ").append("}");
    }

    @Override
    void appendInitializeMethodPart(StringBuilder sb) {
        sb.append("fun initialize()");
    }

    @Override
    void appendAssertions(SkeletonContext context, StringBuilder sb) {
        for (String assertion : context.getAssertions()) {
            sb.append("    ").append("    ").append("assert(").append(assertion).append(" != null) {").append("\"fx:id=\\\"").append(assertion).append("\\\" was not injected: check your FXML file ").append("'").append(context.getDocumentName()).append("'.\" }").append(NL);
        }
    }
}

