/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.skeleton;

import com.oracle.javafx.scenebuilder.kit.skeleton.SkeletonSettings;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

class SkeletonFileNameProposal {
    private static final String DEFAULT_CONTROLLER_CLASS_NAME = "PleaseProvideControllerClassName";
    private final SkeletonSettings.LANGUAGE language;

    public SkeletonFileNameProposal(SkeletonSettings.LANGUAGE language) {
        this.language = language;
    }

    public File create(URL fxmlLocation, String fxControllerName) {
        if (fxControllerName == null || fxControllerName.isBlank()) {
            if (null != fxmlLocation) {
                File controllerAtFxmlLocation = this.createFileAccordingToFxml(fxmlLocation);
                return this.adjustToSrcMainDirWhenPossible(controllerAtFxmlLocation);
            }
        } else {
            File fromControllerName = this.createFileFromControllerName(fxmlLocation, fxControllerName);
            return this.adjustToSrcMainDirWhenPossible(fromControllerName);
        }
        return this.createFileInUserDir();
    }

    private File adjustToSrcMainDirWhenPossible(File controllerAtFxmlLocation) {
        String location = controllerAtFxmlLocation.toPath().toString().replace('\\', '/');
        List<Path> sourcePackages = List.of(Paths.get("src/main", new String[0]));
        for (Path sourcePackage : sourcePackages) {
            String resources = this.resolvePath(sourcePackage, "resources");
            String java = this.resolvePath(sourcePackage, "java");
            String kotlin = this.resolvePath(sourcePackage, "kotlin");
            if (!location.contains(resources)) continue;
            switch (this.language) {
                case JAVA: {
                    location = location.replace(resources, java);
                    break;
                }
                case KOTLIN: {
                    location = location.replace(resources, kotlin);
                    break;
                }
            }
        }
        File adjustedLocation = new File(location);
        if (Files.exists(adjustedLocation.toPath().getParent(), new LinkOption[0])) {
            return adjustedLocation;
        }
        return controllerAtFxmlLocation;
    }

    private String resolvePath(Path source, String child) {
        return source.resolve(child).toString().replace('\\', '/');
    }

    private File createFileFromControllerName(URL fxmlLocation, String fxControllerName) {
        URI uri;
        Path location;
        String directory = this.obtainUserDirectory();
        if (null != fxmlLocation && Files.exists(location = Paths.get(uri = this.resolveURI(fxmlLocation)).toAbsolutePath().getParent(), new LinkOption[0])) {
            directory = location.toString();
        }
        String simpleControllerClassName = this.extractSimpleControllerName(fxControllerName);
        String controllerFileName = simpleControllerClassName + this.language.getExtension();
        return new File(directory, controllerFileName);
    }

    private URI resolveURI(URL fxmlLocation) {
        try {
            return fxmlLocation.toURI();
        }
        catch (URISyntaxException e) {
            File userDir = new File(this.obtainUserDirectory()).getAbsoluteFile();
            return userDir.toURI();
        }
    }

    private File createFileAccordingToFxml(URL fxmlLocation) {
        URI uri = this.resolveURI(fxmlLocation);
        Path fxmlFile = Paths.get(uri);
        String fxmlResource = fxmlFile.toString();
        String controllerSuffix = "Controller" + this.language.getExtension();
        int lastDot = fxmlResource.lastIndexOf(46);
        if (lastDot > -1) {
            String newFileName = fxmlResource.substring(0, lastDot) + controllerSuffix;
            return Paths.get(newFileName, new String[0]).toFile();
        }
        return Paths.get(fxmlResource + controllerSuffix, new String[0]).toFile();
    }

    private File createFileInUserDir() {
        String fileName = DEFAULT_CONTROLLER_CLASS_NAME + this.language.getExtension();
        String userDirectory = this.obtainUserDirectory();
        return this.buildFileName(userDirectory, fileName);
    }

    private String obtainUserDirectory() {
        return System.getProperty("user.home");
    }

    private File buildFileName(String userDirectory, String fileName) {
        return Paths.get(userDirectory, fileName).normalize().toAbsolutePath().toFile();
    }

    private String extractSimpleControllerName(String fxControllerName) {
        String simpleName = fxControllerName.replace("$", ".");
        int dot = simpleName.lastIndexOf(46);
        if (dot > -1) {
            simpleName = simpleName.substring(dot + 1);
        }
        return simpleName;
    }
}

