/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.skeleton;

import com.oracle.javafx.scenebuilder.kit.skeleton.SkeletonFileNameProposal;
import com.oracle.javafx.scenebuilder.kit.skeleton.SkeletonFileWriterErrorAlert;
import com.oracle.javafx.scenebuilder.kit.skeleton.SkeletonFileWriterSuccessAlert;
import com.oracle.javafx.scenebuilder.kit.skeleton.SkeletonSettings;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;

final class SkeletonFileWriter {
    private final Supplier<Stage> stageSupplier;
    private final Map<SkeletonSettings.LANGUAGE, File> savedFilePerLanguage;
    private final Map<SkeletonSettings.LANGUAGE, FileChooser.ExtensionFilter> extensionFilterByLanguage;
    private final BiFunction<FileChooser, Stage, File> saveDialogInteraction;
    private final Function<Supplier<Stage>, Consumer<File>> onSuccess;
    private final Function<Supplier<Stage>, BiConsumer<File, Exception>> onError;
    private SkeletonSettings.LANGUAGE language;
    private URL fxmlLocation;
    private String controllerName;
    private FileChooser saveFileChooser;
    private ReadOnlyStringProperty textProperty;

    public SkeletonFileWriter(Supplier<Stage> stageSupplier, ReadOnlyStringProperty textProperty) {
        this(stageSupplier, textProperty, (fileChooser, stage) -> fileChooser.showSaveDialog((Window)stage), SkeletonFileWriterSuccessAlert::new, SkeletonFileWriterErrorAlert::new);
    }

    protected SkeletonFileWriter(Supplier<Stage> stageSupplier, ReadOnlyStringProperty textProperty, BiFunction<FileChooser, Stage, File> saveDialogInteraction, Function<Supplier<Stage>, Consumer<File>> onSuccessNotify, Function<Supplier<Stage>, BiConsumer<File, Exception>> onErrorNotify) {
        this.stageSupplier = Objects.requireNonNull(stageSupplier);
        this.textProperty = Objects.requireNonNull(textProperty);
        this.saveDialogInteraction = Objects.requireNonNull(saveDialogInteraction);
        this.onSuccess = Objects.requireNonNull(onSuccessNotify);
        this.onError = Objects.requireNonNull(onErrorNotify);
        this.savedFilePerLanguage = new EnumMap<SkeletonSettings.LANGUAGE, File>(SkeletonSettings.LANGUAGE.class);
        this.extensionFilterByLanguage = new EnumMap<SkeletonSettings.LANGUAGE, FileChooser.ExtensionFilter>(SkeletonSettings.LANGUAGE.class);
    }

    public void run(URL fxmlLocation, String fxControllerName, SkeletonSettings.LANGUAGE language) {
        this.fxmlLocation = fxmlLocation;
        this.controllerName = fxControllerName;
        this.language = Objects.requireNonNull(language);
        this.createFileChooserWhenNeeded();
        File fileToSave = this.determineSaveFileName();
        this.updateFileChooser(fileToSave);
        this.saveToFileWhenConfirmed();
    }

    Map<SkeletonSettings.LANGUAGE, File> getLastSavedFilesPerLanguage() {
        return Collections.unmodifiableMap(this.savedFilePerLanguage);
    }

    Function<Supplier<Stage>, Consumer<File>> getOnSuccess() {
        return this.onSuccess;
    }

    Function<Supplier<Stage>, BiConsumer<File, Exception>> getOnError() {
        return this.onError;
    }

    private void saveToFileWhenConfirmed() {
        File confirmedSavedFile = this.saveDialogInteraction.apply(this.saveFileChooser, this.stageSupplier.get());
        if (null != confirmedSavedFile) {
            this.updateFileChooserAndSave(confirmedSavedFile);
        }
    }

    private File determineSaveFileName() {
        File fileToSave = this.savedFilePerLanguage.get((Object)this.language);
        if (fileToSave == null) {
            fileToSave = new SkeletonFileNameProposal(this.language).create(this.fxmlLocation, this.controllerName);
        }
        return fileToSave;
    }

    private void createFileChooserWhenNeeded() {
        if (this.saveFileChooser == null) {
            this.saveFileChooser = new FileChooser();
            this.createExtensionFilters();
        }
    }

    private void createExtensionFilters() {
        for (SkeletonSettings.LANGUAGE lang : SkeletonSettings.LANGUAGE.values()) {
            FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter(lang.toString(), new String[]{"*" + lang.getExtension()});
            this.extensionFilterByLanguage.put(lang, filter);
            this.saveFileChooser.getExtensionFilters().add((Object)filter);
        }
    }

    private void updateFileChooser(File fileToSave) {
        this.saveFileChooser.setInitialDirectory(fileToSave.getParentFile());
        this.saveFileChooser.setInitialFileName(fileToSave.getName());
        this.saveFileChooser.setSelectedExtensionFilter(this.extensionFilterByLanguage.get((Object)this.language));
    }

    private void updateFileChooserAndSave(File savedFile) {
        this.updateFileChooser(savedFile);
        this.rememberLastSavedFilePerLanguage(savedFile);
        this.saveToFile(savedFile.toPath().toAbsolutePath());
    }

    private void rememberLastSavedFilePerLanguage(File savedFile) {
        this.savedFilePerLanguage.put(this.language, savedFile);
    }

    private void saveToFile(Path skeletonFile) {
        try {
            this.writeSkeletonFileAndNotifyUser(skeletonFile);
        }
        catch (IOException error) {
            this.logErrorAndNotifyUser(skeletonFile, error);
        }
    }

    private void writeSkeletonFileAndNotifyUser(Path skeletonFile) throws IOException {
        String skeleton = this.textProperty.getValueSafe();
        StandardOpenOption openOption = Files.exists(skeletonFile, new LinkOption[0]) ? StandardOpenOption.TRUNCATE_EXISTING : StandardOpenOption.CREATE_NEW;
        Files.write(skeletonFile, skeleton.getBytes(), openOption);
        this.onSuccess.apply(this.stageSupplier).accept(skeletonFile.toFile());
    }

    private void logErrorAndNotifyUser(Path skeletonFile, IOException error) {
        this.onError.apply(this.stageSupplier).accept(skeletonFile.toFile(), error);
        Logger logger = Logger.getLogger(SkeletonFileWriter.class.getSimpleName());
        String template = "Could not write controller skeleton to file: %s .";
        logger.log(Level.SEVERE, String.format(template, skeletonFile.normalize().toAbsolutePath()), error);
    }
}

