/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.skeleton;

import com.oracle.javafx.scenebuilder.kit.alert.SBAlert;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.TextArea;
import javafx.stage.Stage;

final class SkeletonFileWriterErrorAlert
implements BiConsumer<File, Exception> {
    private final Supplier<Stage> stageSupplier;

    SkeletonFileWriterErrorAlert(Supplier<Stage> stageSupplier) {
        this.stageSupplier = Objects.requireNonNull(stageSupplier);
    }

    @Override
    public void accept(File skeletonFile, Exception error) {
        SBAlert alert = this.prepareErrorAlert(skeletonFile, error);
        String exceptionDetails = this.collectExceptionDetails(error);
        TextArea textArea = new TextArea(exceptionDetails);
        textArea.setEditable(false);
        textArea.setWrapText(true);
        textArea.setMaxWidth(Double.MAX_VALUE);
        textArea.setMaxHeight(Double.MAX_VALUE);
        alert.getDialogPane().setExpandableContent((Node)textArea);
        Platform.runLater(() -> alert.showAndWait());
    }

    private SBAlert prepareErrorAlert(File skeletonFile, Exception error) {
        SBAlert alert = new SBAlert(Alert.AlertType.ERROR, this.stageSupplier.get());
        alert.setTitle(I18N.getString("alert.skeleton.title"));
        alert.setHeaderText(I18N.getString("alert.skeleton.header.failed"));
        alert.setContentText(I18N.getString("alert.skeleton.saving.failed") + "\n" + String.valueOf(skeletonFile) + "\n\n" + error.getLocalizedMessage());
        return alert;
    }

    private String collectExceptionDetails(Exception error) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        error.printStackTrace(printWriter);
        return stringWriter.toString();
    }
}

