/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.skeleton;

import com.oracle.javafx.scenebuilder.kit.alert.SBAlert;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.DialogPane;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.shape.SVGPath;
import javafx.stage.Stage;

final class SkeletonFileWriterSuccessAlert
implements Consumer<File> {
    private final Supplier<Stage> stageSupplier;

    SkeletonFileWriterSuccessAlert(Supplier<Stage> stageSupplier) {
        this.stageSupplier = Objects.requireNonNull(stageSupplier);
    }

    @Override
    public void accept(File fileWritten) {
        SBAlert alert = this.prepareSuccessAlert();
        DialogPane dialogPane = alert.getDialogPane();
        TextField textField = new TextField(fileWritten.toString());
        textField.setEditable(false);
        Button copyButton = this.createCopyToClipboardButton(textField);
        HBox hbox = new HBox(new Node[]{textField, copyButton});
        HBox.setHgrow((Node)textField, (Priority)Priority.ALWAYS);
        dialogPane.setContent((Node)hbox);
        Platform.runLater(() -> alert.showAndWait());
    }

    private SBAlert prepareSuccessAlert() {
        SBAlert alert = new SBAlert(Alert.AlertType.INFORMATION, this.stageSupplier.get());
        alert.setTitle(I18N.getString("alert.skeleton.title"));
        alert.setHeaderText(I18N.getString("alert.skeleton.header.success"));
        return alert;
    }

    private Button createCopyToClipboardButton(TextField textField) {
        SVGPath clipboardIcon = new SVGPath();
        clipboardIcon.setContent("M11.983,1.973L11.983,12.001L3.935,12.001L3.935,1.973L3.319,1.973C2.577,1.973 1.975,2.575 1.975,3.317L1.975,12.684C1.975,13.426 2.577,14.029 3.319,14.029L12.644,14.029C13.386,14.029 13.989,13.426 13.989,12.684L13.989,3.317C13.989,2.575 13.386,1.973 12.644,1.973L11.983,1.973ZM10.959,0.997L4.965,0.997L4.965,5.018L10.959,5.018L10.959,0.997ZM10.021,3.948L10.038,3.948L10.038,1.932L6.016,1.932L6.016,3.948L6.034,3.948L6.034,4.005L10.021,4.005L10.021,3.948Z");
        Button copyButton = new Button(null, (Node)clipboardIcon);
        copyButton.setTooltip(new Tooltip(I18N.getString("alert.skeleton.copy2clipboard")));
        copyButton.setOnAction(event -> Clipboard.getSystemClipboard().setContent(Map.of(DataFormat.PLAIN_TEXT, textField.getText())));
        return copyButton;
    }
}

