/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.skeleton;

class SkeletonSettings {
    private LANGUAGE language = LANGUAGE.JAVA;
    private TEXT_TYPE textType = TEXT_TYPE.WITHOUT_COMMENTS;
    private FORMAT_TYPE textFormat = FORMAT_TYPE.COMPACT;

    SkeletonSettings() {
    }

    void setLanguage(LANGUAGE language) {
        this.language = language;
    }

    public LANGUAGE getLanguage() {
        return this.language;
    }

    void setTextType(TEXT_TYPE type) {
        this.textType = type;
    }

    SkeletonSettings withTextType(TEXT_TYPE type) {
        this.textType = type;
        return this;
    }

    void setFormat(FORMAT_TYPE format) {
        this.textFormat = format;
    }

    SkeletonSettings withFormat(FORMAT_TYPE format) {
        this.textFormat = format;
        return this;
    }

    boolean isWithComments() {
        return this.textType == TEXT_TYPE.WITH_COMMENTS;
    }

    boolean isFull() {
        return this.textFormat == FORMAT_TYPE.FULL;
    }

    static enum LANGUAGE {
        JAVA("Java", ".java"),
        KOTLIN("Kotlin", ".kt"),
        JRUBY("JRuby", ".rb");

        private final String name;
        private final String ext;

        private LANGUAGE(String name, String fileNameExt) {
            this.name = name;
            this.ext = fileNameExt;
        }

        public String toString() {
            return this.name;
        }

        String getExtension() {
            return this.ext;
        }
    }

    static enum TEXT_TYPE {
        WITH_COMMENTS,
        WITHOUT_COMMENTS;

    }

    static enum FORMAT_TYPE {
        COMPACT,
        FULL;

    }
}

