/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.skeleton;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractFxmlWindowController;
import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.skeleton.SkeletonBuffer;
import com.oracle.javafx.scenebuilder.kit.skeleton.SkeletonFileWriter;
import com.oracle.javafx.scenebuilder.kit.skeleton.SkeletonSettings;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TextArea;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;

public class SkeletonWindowController
extends AbstractFxmlWindowController {
    @FXML
    ChoiceBox<SkeletonSettings.LANGUAGE> languageChoiceBox;
    @FXML
    CheckBox commentCheckBox;
    @FXML
    CheckBox formatCheckBox;
    @FXML
    TextArea textArea;
    private String controllerName = null;
    private SkeletonFileWriter skeletonFileWriter = null;
    private final EditorController editorController;
    private boolean dirty = false;
    private final String documentName;
    private final KeyCodeCombination copyAccelerator;
    private EventHandler<KeyEvent> keyEventHandler;
    private final InvalidationListener fxomDocumentRevisionListener = observable -> this.update();

    @FXML
    private void onCopyAction(ActionEvent event) {
        String content = "";
        content = this.textArea.getSelection().getLength() == 0 ? this.textArea.getText() : this.textArea.getSelectedText();
        ClipboardContent newContent = new ClipboardContent();
        newContent.putString(content);
        Clipboard.getSystemClipboard().setContent((Map)newContent);
    }

    @FXML
    private void onSaveAction(ActionEvent event) {
        if (this.skeletonFileWriter == null) {
            this.skeletonFileWriter = new SkeletonFileWriter(() -> this.getStage(), (ReadOnlyStringProperty)this.textArea.textProperty());
        }
        SkeletonSettings.LANGUAGE language = (SkeletonSettings.LANGUAGE)((Object)this.languageChoiceBox.getSelectionModel().getSelectedItem());
        this.skeletonFileWriter.run(this.editorController.getFxmlLocation(), this.controllerName, language);
    }

    public SkeletonWindowController(EditorController editorController, String documentName, Stage owner) {
        super(SkeletonWindowController.class.getResource("SkeletonWindow.fxml"), I18N.getBundle(), owner);
        this.editorController = editorController;
        this.documentName = documentName;
        this.editorController.fxomDocumentProperty().addListener((ov, od, nd) -> {
            assert (editorController.getFxomDocument() == nd);
            if (od != null) {
                od.sceneGraphRevisionProperty().removeListener(this.fxomDocumentRevisionListener);
            }
            if (nd != null) {
                nd.sceneGraphRevisionProperty().addListener(this.fxomDocumentRevisionListener);
                this.update();
            }
        });
        if (editorController.getFxomDocument() != null) {
            editorController.getFxomDocument().sceneGraphRevisionProperty().addListener(this.fxomDocumentRevisionListener);
        }
        this.copyAccelerator = new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
    }

    private void handleCopyToClipboardEvent(KeyEvent event, boolean condition, boolean modifier) {
        if (condition && modifier) {
            Platform.runLater(() -> this.onCopyAction(null));
            event.consume();
        }
    }

    @Override
    public void onCloseRequest(WindowEvent event) {
        this.getStage().close();
    }

    @Override
    public void openWindow() {
        super.openWindow();
        if (this.keyEventHandler == null) {
            this.keyEventHandler = event -> this.handleCopyToClipboardEvent((KeyEvent)event, event.getCode() == KeyCode.C, event.isShortcutDown());
            this.textArea.addEventFilter(KeyEvent.KEY_PRESSED, this.keyEventHandler);
            this.getStage().getScene().getAccelerators().put((Object)this.copyAccelerator, () -> Platform.runLater(() -> this.onCopyAction(null)));
        }
        if (this.dirty) {
            this.update();
        }
    }

    @Override
    protected void controllerDidLoadFxml() {
        super.controllerDidLoadFxml();
        assert (this.languageChoiceBox != null);
        assert (this.commentCheckBox != null);
        assert (this.formatCheckBox != null);
        assert (this.textArea != null);
        this.languageChoiceBox.getItems().addAll((Object[])SkeletonSettings.LANGUAGE.values());
        this.languageChoiceBox.getSelectionModel().select((Object)SkeletonSettings.LANGUAGE.JAVA);
        this.languageChoiceBox.getSelectionModel().selectedItemProperty().addListener(this.fxomDocumentRevisionListener);
        this.commentCheckBox.selectedProperty().addListener(this.fxomDocumentRevisionListener);
        this.formatCheckBox.selectedProperty().addListener(this.fxomDocumentRevisionListener);
        this.update();
    }

    private void updateTitle() {
        String title = I18N.getString("skeleton.window.title", this.documentName);
        this.getStage().setTitle(title);
    }

    private void update() {
        assert (this.editorController.getFxomDocument() != null);
        if (this.getStage().isShowing()) {
            this.updateTitle();
            SkeletonBuffer buf = new SkeletonBuffer(this.editorController.getFxomDocument(), this.documentName);
            buf.setLanguage((SkeletonSettings.LANGUAGE)((Object)this.languageChoiceBox.getSelectionModel().getSelectedItem()));
            if (this.commentCheckBox.isSelected()) {
                buf.setTextType(SkeletonSettings.TEXT_TYPE.WITH_COMMENTS);
            } else {
                buf.setTextType(SkeletonSettings.TEXT_TYPE.WITHOUT_COMMENTS);
            }
            if (this.formatCheckBox.isSelected()) {
                buf.setFormat(SkeletonSettings.FORMAT_TYPE.FULL);
            } else {
                buf.setFormat(SkeletonSettings.FORMAT_TYPE.COMPACT);
            }
            this.controllerName = this.editorController.getFxomDocument().getFxomRoot().getFxController();
            this.textArea.setText(buf.toString());
            this.dirty = false;
        } else {
            this.dirty = true;
        }
    }
}

