/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.template;

import com.oracle.javafx.scenebuilder.kit.i18n.I18N;
import com.oracle.javafx.scenebuilder.kit.template.Type;
import java.net.URL;
import javafx.scene.image.Image;

public enum Template {
    EMPTY_APP(Type.DESKTOP, "EmptyApplication.fxml", "empty_desktop.png", "template.title.new.empty.app", "template.description.new.empty.app"),
    BASIC_DESKTOP_APP(Type.DESKTOP, "BasicDesktopApplication.fxml", "basic_desktop.png", "template.title.new.basic.desktop.app", "template.description.new.basic.desktop.app"),
    COMPLEX_DESKTOP_APP(Type.DESKTOP, "ComplexDesktopApplication.fxml", "complex_desktop.png", "template.title.new.complex.desktop.app", "template.description.new.complex.desktop.app"),
    EMPTY_PHONE_APP(Type.PHONE, "EmptyPhoneApplication.fxml", "empty_mobile.png", "template.title.new.empty.phone.app", "template.description.new.empty.phone.app"),
    BASIC_PHONE_APP(Type.PHONE, "BasicPhoneApplication.fxml", "basic_mobile.png", "template.title.new.basic.phone.app", "template.description.new.basic.phone.app");

    private Type type;
    private String fxmlFileName;
    private String imageFileName;
    private String uiNameKey;
    private String descriptionKey;

    private Template(Type type, String fxmlFileName, String imageFileName, String uiNameKey, String descriptionKey) {
        this.type = type;
        this.fxmlFileName = fxmlFileName;
        this.imageFileName = imageFileName;
        this.uiNameKey = uiNameKey;
        this.descriptionKey = descriptionKey;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isDesktop() {
        return this.type == Type.DESKTOP;
    }

    public URL getFXMLURL() {
        return Template.class.getResource(this.fxmlFileName);
    }

    public Image getImage() {
        return new Image(Template.class.getResource(this.imageFileName).toExternalForm());
    }

    public String getUiName() {
        return I18N.getString(this.uiNameKey);
    }

    public String getDescription() {
        return I18N.getString(this.descriptionKey);
    }
}

