/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.template;

import com.oracle.javafx.scenebuilder.kit.editor.panel.util.AbstractFxmlWindowController;
import com.oracle.javafx.scenebuilder.kit.template.Template;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.ImageView;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;

public abstract class TemplatesBaseWindowController
extends AbstractFxmlWindowController {
    private Consumer<Template> onTemplateChosen = template -> {};

    public TemplatesBaseWindowController(URL fxmlURL, ResourceBundle resources, Stage owner) {
        super(fxmlURL, resources, owner);
    }

    @Override
    public void onCloseRequest(WindowEvent event) {
        this.getStage().hide();
    }

    @Override
    protected void controllerDidCreateStage() {
        assert (this.getRoot() != null);
        assert (this.getRoot().getScene() != null);
        assert (this.getRoot().getScene().getWindow() != null);
    }

    @Override
    protected void controllerDidLoadFxml() {
        super.controllerDidLoadFxml();
        this.initTemplates();
    }

    private void initTemplates() {
        FlowPane mobilePane;
        FlowPane desktopPane;
        try {
            ScrollPane templatesRoot = (ScrollPane)this.getRoot().lookup("#templatesRoot");
            desktopPane = (FlowPane)templatesRoot.getContent().lookup("#desktopPane");
            mobilePane = (FlowPane)templatesRoot.getContent().lookup("#mobilePane");
        }
        catch (Exception e2) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Failed to lookup() [desktopPane] and [mobilePane]:", e2);
            return;
        }
        for (Template template : Template.values()) {
            try {
                VBox btnRoot = (VBox)FXMLLoader.load((URL)TemplatesBaseWindowController.class.getResource("Template.fxml"));
                Button button = (Button)btnRoot.lookup("#button");
                button.setText(template.getUiName());
                button.setOnAction(e -> this.onTemplateChosen.accept(template));
                ImageView view = (ImageView)button.getGraphic();
                view.setImage(template.getImage());
                Label label = (Label)btnRoot.lookup("#labelDescription");
                label.setText(template.getDescription());
                if (template.isDesktop()) {
                    desktopPane.getChildren().add((Object)btnRoot);
                    continue;
                }
                mobilePane.getChildren().add((Object)btnRoot);
            }
            catch (Exception e3) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Failed to load template: " + String.valueOf((Object)template), e3);
            }
        }
    }

    public void setOnTemplateChosen(Consumer<Template> onTemplateChosen) {
        this.onTemplateChosen = onTemplateChosen;
    }
}

