/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.util;

import com.oracle.javafx.scenebuilder.kit.util.ReflectionUtils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.css.CssMetaData;
import javafx.css.Style;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.SubScene;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.GridPane;

public class Deprecation {
    private Deprecation() {
        assert (false);
    }

    public static Group createGroupWithNullParentStylesheets() {
        return new Group(){};
    }

    public static void setStyleMap(Node node, ObservableMap<StyleableProperty<?>, List<Style>> map) {
    }

    public static Map<StyleableProperty<?>, List<Style>> getStyleMap(Node node) {
        return null;
    }

    public static void reapplyCSS(Parent parent, URI stylesheetPath) {
        try {
            Deprecation.reapplyCSS(parent, stylesheetPath.toURL());
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(Deprecation.class.getName()).log(Level.SEVERE, "Error while retrieving the URL", ex);
        }
    }

    private static void reapplyCSS(Parent parent, URL stylesheetPath) {
        ObservableList stylesheets = parent.getStylesheets();
        for (String s : new LinkedList(stylesheets)) {
            if (!s.endsWith(stylesheetPath.getPath())) continue;
            int index = stylesheets.indexOf(s);
            assert (index != -1);
            stylesheets.remove(index);
            stylesheets.add(index, s);
            break;
        }
        for (Node child : parent.getChildrenUnmodifiable()) {
            if (child instanceof Parent) {
                Parent childParent = (Parent)child;
                Deprecation.reapplyCSS(childParent, stylesheetPath);
                continue;
            }
            if (!(child instanceof SubScene)) continue;
            SubScene childSubScene = (SubScene)child;
            Deprecation.reapplyCSS(childSubScene.getRoot(), stylesheetPath);
        }
    }

    public static List<Style> getMatchingStyles(CssMetaData cssMetaData, Styleable styleable) {
        return null;
    }

    public static void setStaticLoad(FXMLLoader loader, boolean staticLoad) {
        ReflectionUtils.setStaticLoad(loader, staticLoad);
    }

    public static Node pick(Node node, double sceneX, double sceneY) {
        Point2D p = node.sceneToLocal(sceneX, sceneY, true);
        if (!node.contains(p)) {
            return null;
        }
        if (node instanceof Parent) {
            Node bestMatchingChild = null;
            for (Node child : ((Parent)node).getChildrenUnmodifiable()) {
                if (!child.contains(p = child.sceneToLocal(sceneX, sceneY, true))) continue;
                bestMatchingChild = child;
            }
            if (bestMatchingChild != null) {
                return Deprecation.pick(bestMatchingChild, sceneX, sceneY);
            }
        }
        return node;
    }

    public static int getGridPaneColumnCount(GridPane gridPane) {
        return gridPane.getColumnCount();
    }

    public static int getGridPaneRowCount(GridPane gridPane) {
        return gridPane.getRowCount();
    }

    public static Bounds getGridPaneCellBounds(GridPane gridPane, int c, int r) {
        return gridPane.getCellBounds(c, r);
    }

    public static int getNodeLevel(TreeItem<?> item) {
        return TreeView.getNodeLevel(item);
    }

    public static Point2D localToLocal(Node source, double sourceX, double sourceY, Node target) {
        Point2D sceneXY = source.localToScene(sourceX, sourceY, true);
        return target.sceneToLocal(sceneXY, true);
    }

    public static Bounds localToLocal(Node source, Bounds sourceBounds, Node target) {
        Bounds sceneBounds = source.localToScene(sourceBounds, true);
        return target.sceneToLocal(sceneBounds, true);
    }
}

