/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.util;

import java.util.List;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;

public class PaintConvertUtil {
    private static final int ROUNDING_FACTOR = 10000;

    PaintConvertUtil() {
    }

    public static String convertPaintToCss(Paint fxPaint) {
        if (fxPaint instanceof LinearGradient) {
            LinearGradient paint = (LinearGradient)fxPaint;
            StringBuilder strBuilder = new StringBuilder("linear-gradient(from ").append(PaintConvertUtil.lenToStr(paint.getStartX(), paint.isProportional())).append(" ").append(PaintConvertUtil.lenToStr(paint.getStartY(), paint.isProportional())).append(" to ").append(PaintConvertUtil.lenToStr(paint.getEndX(), paint.isProportional())).append(" ").append(PaintConvertUtil.lenToStr(paint.getEndY(), paint.isProportional())).append(", ");
            PaintConvertUtil.connectCycleMethodAndStops(strBuilder, paint.getCycleMethod(), paint.getStops());
            return strBuilder.toString();
        }
        if (fxPaint instanceof RadialGradient) {
            RadialGradient paint = (RadialGradient)fxPaint;
            StringBuilder strBuilder = new StringBuilder("radial-gradient(focus-angle ").append(PaintConvertUtil.round(paint.getFocusAngle())).append("deg, focus-distance ").append(PaintConvertUtil.round(paint.getFocusDistance() * 100.0)).append("% , center ").append(PaintConvertUtil.lenToStr(paint.getCenterX(), paint.isProportional())).append(" ").append(PaintConvertUtil.lenToStr(paint.getCenterY(), paint.isProportional())).append(", radius ").append(PaintConvertUtil.lenToStr(paint.getRadius(), paint.isProportional())).append(", ");
            PaintConvertUtil.connectCycleMethodAndStops(strBuilder, paint.getCycleMethod(), paint.getStops());
            return strBuilder.toString();
        }
        if (fxPaint instanceof Color) {
            return PaintConvertUtil.toHex((Color)fxPaint);
        }
        return "";
    }

    public static String convertPaintToJavaCode(Paint fxPaint) {
        if (fxPaint instanceof LinearGradient) {
            LinearGradient paint = (LinearGradient)fxPaint;
            return "LinearGradient paint = new LinearGradient(" + System.lineSeparator() + PaintConvertUtil.round(paint.getStartX()) + ", " + PaintConvertUtil.round(paint.getStartY()) + ", " + PaintConvertUtil.round(paint.getEndX()) + ", " + PaintConvertUtil.round(paint.getEndY()) + ", " + paint.isProportional() + ", " + PaintConvertUtil.cycleMethodToStr(paint.getCycleMethod()) + "," + System.lineSeparator() + PaintConvertUtil.stopsToString(paint.getStops()) + ");";
        }
        if (fxPaint instanceof RadialGradient) {
            RadialGradient paint = (RadialGradient)fxPaint;
            return "RadialGradient paint = new RadialGradient(" + System.lineSeparator() + PaintConvertUtil.round(paint.getFocusAngle()) + ", " + PaintConvertUtil.round(paint.getFocusDistance()) + ", " + PaintConvertUtil.round(paint.getCenterX()) + ", " + PaintConvertUtil.round(paint.getCenterY()) + ", " + PaintConvertUtil.round(paint.getRadius()) + ", " + paint.isProportional() + ", " + PaintConvertUtil.cycleMethodToStr(paint.getCycleMethod()) + "," + System.lineSeparator() + PaintConvertUtil.stopsToString(paint.getStops()) + ");";
        }
        if (fxPaint instanceof Color) {
            return "Color paint = " + PaintConvertUtil.colorToJavaStr((Color)fxPaint) + ";";
        }
        return "";
    }

    private static void connectCycleMethodAndStops(StringBuilder strBuilder, CycleMethod cycleMethod, List<Stop> stops) {
        switch (cycleMethod) {
            case REFLECT: {
                strBuilder.append("reflect").append(", ");
                break;
            }
            case REPEAT: {
                strBuilder.append("repeat").append(", ");
                break;
            }
        }
        int len = stops.size();
        for (int i = 0; i < len; ++i) {
            Stop stop = stops.get(i);
            strBuilder.append(PaintConvertUtil.toHex(stop.getColor())).append(" ").append(PaintConvertUtil.round(stop.getOffset() * 100.0)).append("%");
            if (i >= len - 1) continue;
            strBuilder.append(", ");
        }
        strBuilder.append(")");
    }

    private static String cycleMethodToStr(CycleMethod cycleMethod) {
        String cycleMethodStr = CycleMethod.REFLECT.equals((Object)cycleMethod) ? "CycleMethod.REFLECT" : (CycleMethod.REPEAT.equals((Object)cycleMethod) ? "CycleMethod.REPEAT" : "CycleMethod.NO_CYCLE");
        return cycleMethodStr;
    }

    private static String stopsToString(List<Stop> stops) {
        StringBuilder stopsBuilder = new StringBuilder(32);
        int len = stops.size();
        for (int i = 0; i < len; ++i) {
            Stop stop = stops.get(i);
            Color color = stop.getColor();
            double offset = PaintConvertUtil.round(stop.getOffset());
            String strColor = PaintConvertUtil.colorToJavaStr(color);
            stopsBuilder.append("new Stop(").append(offset).append(", ").append(strColor).append(")");
            if (i >= len - 1) continue;
            stopsBuilder.append(",").append(System.lineSeparator());
        }
        return stopsBuilder.toString();
    }

    private static String colorToJavaStr(Color color) {
        return String.format("new Color(%s, %s, %s, %s)", PaintConvertUtil.round(color.getRed()), PaintConvertUtil.round(color.getGreen()), PaintConvertUtil.round(color.getBlue()), PaintConvertUtil.round(color.getOpacity()));
    }

    private static String lenToStr(double num, boolean isProportional) {
        return isProportional ? PaintConvertUtil.round(num * 100.0) + "%" : num + "px";
    }

    private static double round(double num) {
        double doubleRounded = Math.round(num * 10000.0);
        return doubleRounded / 10000.0;
    }

    private static String toHex(Color color) {
        int red = (int)Math.round(color.getRed() * 255.0);
        int green = (int)Math.round(color.getGreen() * 255.0);
        int blue = (int)Math.round(color.getBlue() * 255.0);
        int alpha = (int)Math.round(color.getOpacity() * 255.0);
        if (alpha == 255) {
            return String.format("#%02x%02x%02x", red, green, blue);
        }
        return String.format("#%02x%02x%02x%02x", red, green, blue, alpha);
    }
}

