/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXMLLoader;

public class ReflectionUtils {
    private static final Map<String, Method> methodMap = new HashMap<String, Method>();

    private ReflectionUtils() {
    }

    public static void setStaticLoad(FXMLLoader loader, boolean staticLoad) {
        Class<?> clazz = loader.getClass();
        Method setStaticLoadMethod = methodMap.computeIfAbsent(clazz.getName(), s -> {
            try {
                Method method = clazz.getDeclaredMethod("setStaticLoad", Boolean.TYPE);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException e) {
                Logger.getLogger(ReflectionUtils.class.getName()).log(Level.WARNING, "Failed to find method setStaticLoad: ", e);
                return null;
            }
        });
        if (setStaticLoadMethod != null) {
            try {
                setStaticLoadMethod.invoke((Object)loader, staticLoad);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                Logger.getLogger(ReflectionUtils.class.getName()).log(Level.WARNING, "Failed to invoke method setStaticLoad: ", e);
            }
        }
    }
}

