/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.util.control.effectpicker;

import javafx.scene.effect.Blend;
import javafx.scene.effect.Bloom;
import javafx.scene.effect.BoxBlur;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.ColorInput;
import javafx.scene.effect.DisplacementMap;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.effect.Glow;
import javafx.scene.effect.ImageInput;
import javafx.scene.effect.InnerShadow;
import javafx.scene.effect.Lighting;
import javafx.scene.effect.MotionBlur;
import javafx.scene.effect.PerspectiveTransform;
import javafx.scene.effect.Reflection;
import javafx.scene.effect.SepiaTone;
import javafx.scene.effect.Shadow;

public abstract class Utils {
    Utils() {
    }

    public static final Effect newInstance(Class<? extends Effect> clazz) {
        assert (clazz != null);
        return Utils.newInstance(clazz.getSimpleName());
    }

    static final Effect newInstance(String text) {
        assert (text != null);
        assert (!text.isEmpty());
        if (text.equals(Blend.class.getSimpleName())) {
            return new Blend();
        }
        if (text.equals(Bloom.class.getSimpleName())) {
            return new Bloom();
        }
        if (text.equals(BoxBlur.class.getSimpleName())) {
            return new BoxBlur();
        }
        if (text.equals(ColorAdjust.class.getSimpleName())) {
            return new ColorAdjust();
        }
        if (text.equals(ColorInput.class.getSimpleName())) {
            return new ColorInput();
        }
        if (text.equals(DisplacementMap.class.getSimpleName())) {
            return new DisplacementMap();
        }
        if (text.equals(DropShadow.class.getSimpleName())) {
            return new DropShadow();
        }
        if (text.equals(GaussianBlur.class.getSimpleName())) {
            return new GaussianBlur();
        }
        if (text.equals(Glow.class.getSimpleName())) {
            return new Glow();
        }
        if (text.equals(ImageInput.class.getSimpleName())) {
            return new ImageInput();
        }
        if (text.equals(InnerShadow.class.getSimpleName())) {
            return new InnerShadow();
        }
        if (text.equals(Lighting.class.getSimpleName())) {
            return new Lighting();
        }
        if (text.equals(MotionBlur.class.getSimpleName())) {
            return new MotionBlur();
        }
        if (text.equals(PerspectiveTransform.class.getSimpleName())) {
            return new PerspectiveTransform();
        }
        if (text.equals(Reflection.class.getSimpleName())) {
            return new Reflection();
        }
        if (text.equals(SepiaTone.class.getSimpleName())) {
            return new SepiaTone();
        }
        if (text.equals(Shadow.class.getSimpleName())) {
            return new Shadow();
        }
        assert (false);
        return null;
    }

    public static Effect clone(Effect effect) {
        Blend clone;
        if (effect == null) {
            clone = null;
        } else if (effect instanceof Blend) {
            Blend blend = (Blend)effect;
            clone = new Blend(blend.getMode());
            clone.setOpacity(blend.getOpacity());
            clone.setBottomInput(Utils.clone(blend.getBottomInput()));
            clone.setTopInput(Utils.clone(blend.getTopInput()));
        } else if (effect instanceof Bloom) {
            Bloom bloom = (Bloom)effect;
            clone = new Bloom(bloom.getThreshold());
            ((Bloom)clone).setInput(Utils.clone(bloom.getInput()));
        } else if (effect instanceof BoxBlur) {
            BoxBlur boxBlur = (BoxBlur)effect;
            clone = new BoxBlur(boxBlur.getWidth(), boxBlur.getHeight(), boxBlur.getIterations());
            ((BoxBlur)clone).setInput(Utils.clone(boxBlur.getInput()));
        } else if (effect instanceof ColorAdjust) {
            ColorAdjust colorAdjust = (ColorAdjust)effect;
            clone = new ColorAdjust(colorAdjust.getHue(), colorAdjust.getSaturation(), colorAdjust.getBrightness(), colorAdjust.getContrast());
            ((ColorAdjust)clone).setInput(Utils.clone(colorAdjust.getInput()));
        } else if (effect instanceof ColorInput) {
            ColorInput colorInput = (ColorInput)effect;
            clone = new ColorInput(colorInput.getX(), colorInput.getY(), colorInput.getWidth(), colorInput.getHeight(), colorInput.getPaint());
        } else if (effect instanceof DisplacementMap) {
            DisplacementMap displacementMap = (DisplacementMap)effect;
            clone = new DisplacementMap(displacementMap.getMapData(), displacementMap.getOffsetX(), displacementMap.getOffsetY(), displacementMap.getScaleX(), displacementMap.getScaleY());
            ((DisplacementMap)clone).setWrap(displacementMap.isWrap());
            ((DisplacementMap)clone).setInput(Utils.clone(displacementMap.getInput()));
        } else if (effect instanceof DropShadow) {
            DropShadow dropShadow = (DropShadow)effect;
            clone = new DropShadow(dropShadow.getBlurType(), dropShadow.getColor(), dropShadow.getRadius(), dropShadow.getSpread(), dropShadow.getOffsetX(), dropShadow.getOffsetY());
            ((DropShadow)clone).setHeight(dropShadow.getHeight());
            ((DropShadow)clone).setWidth(dropShadow.getWidth());
            ((DropShadow)clone).setInput(Utils.clone(dropShadow.getInput()));
        } else if (effect instanceof GaussianBlur) {
            GaussianBlur gaussianBlur = (GaussianBlur)effect;
            clone = new GaussianBlur(gaussianBlur.getRadius());
            ((GaussianBlur)clone).setInput(Utils.clone(gaussianBlur.getInput()));
        } else if (effect instanceof Glow) {
            Glow glow = (Glow)effect;
            clone = new Glow(glow.getLevel());
            ((Glow)clone).setInput(Utils.clone(glow.getInput()));
        } else if (effect instanceof ImageInput) {
            ImageInput imageInput = (ImageInput)effect;
            clone = new ImageInput(imageInput.getSource(), imageInput.getX(), imageInput.getY());
        } else if (effect instanceof InnerShadow) {
            InnerShadow innerShadow = (InnerShadow)effect;
            clone = new InnerShadow(innerShadow.getBlurType(), innerShadow.getColor(), innerShadow.getRadius(), innerShadow.getChoke(), innerShadow.getOffsetX(), innerShadow.getOffsetY());
            ((InnerShadow)clone).setHeight(innerShadow.getHeight());
            ((InnerShadow)clone).setWidth(innerShadow.getWidth());
            ((InnerShadow)clone).setInput(Utils.clone(innerShadow.getInput()));
        } else if (effect instanceof Lighting) {
            Lighting lighting = (Lighting)effect;
            clone = new Lighting(lighting.getLight());
            ((Lighting)clone).setDiffuseConstant(lighting.getDiffuseConstant());
            ((Lighting)clone).setSpecularConstant(lighting.getSpecularConstant());
            ((Lighting)clone).setSpecularExponent(lighting.getSpecularExponent());
            ((Lighting)clone).setSurfaceScale(lighting.getSurfaceScale());
            ((Lighting)clone).setBumpInput(Utils.clone(lighting.getBumpInput()));
            ((Lighting)clone).setContentInput(Utils.clone(lighting.getContentInput()));
        } else if (effect instanceof MotionBlur) {
            MotionBlur motionBlur = (MotionBlur)effect;
            clone = new MotionBlur(motionBlur.getAngle(), motionBlur.getRadius());
            ((MotionBlur)clone).setInput(Utils.clone(motionBlur.getInput()));
        } else if (effect instanceof PerspectiveTransform) {
            PerspectiveTransform perspectiveTransform = (PerspectiveTransform)effect;
            clone = new PerspectiveTransform(perspectiveTransform.getUlx(), perspectiveTransform.getUly(), perspectiveTransform.getUrx(), perspectiveTransform.getUry(), perspectiveTransform.getLrx(), perspectiveTransform.getLry(), perspectiveTransform.getLlx(), perspectiveTransform.getLly());
            ((PerspectiveTransform)clone).setInput(Utils.clone(perspectiveTransform.getInput()));
        } else if (effect instanceof Reflection) {
            Reflection reflection = (Reflection)effect;
            clone = new Reflection(reflection.getTopOffset(), reflection.getFraction(), reflection.getTopOpacity(), reflection.getBottomOpacity());
            ((Reflection)clone).setInput(Utils.clone(reflection.getInput()));
        } else if (effect instanceof SepiaTone) {
            SepiaTone sepiaTone = (SepiaTone)effect;
            clone = new SepiaTone(sepiaTone.getLevel());
            ((SepiaTone)clone).setInput(Utils.clone(sepiaTone.getInput()));
        } else if (effect instanceof Shadow) {
            Shadow shadow = (Shadow)effect;
            clone = new Shadow(shadow.getBlurType(), shadow.getColor(), shadow.getRadius());
            ((Shadow)clone).setHeight(shadow.getHeight());
            ((Shadow)clone).setWidth(shadow.getWidth());
            ((Shadow)clone).setInput(Utils.clone(shadow.getInput()));
        } else {
            assert (false);
            clone = null;
        }
        return clone;
    }

    public static Effect getDefaultInput(Effect effect) {
        Effect input;
        assert (effect != null);
        if (effect instanceof Blend) {
            input = ((Blend)effect).getTopInput();
        } else if (effect instanceof Bloom) {
            input = ((Bloom)effect).getInput();
        } else if (effect instanceof BoxBlur) {
            input = ((BoxBlur)effect).getInput();
        } else if (effect instanceof ColorAdjust) {
            input = ((ColorAdjust)effect).getInput();
        } else if (effect instanceof ColorInput) {
            input = null;
        } else if (effect instanceof DisplacementMap) {
            input = ((DisplacementMap)effect).getInput();
        } else if (effect instanceof DropShadow) {
            input = ((DropShadow)effect).getInput();
        } else if (effect instanceof GaussianBlur) {
            input = ((GaussianBlur)effect).getInput();
        } else if (effect instanceof Glow) {
            input = ((Glow)effect).getInput();
        } else if (effect instanceof ImageInput) {
            input = null;
        } else if (effect instanceof InnerShadow) {
            input = ((InnerShadow)effect).getInput();
        } else if (effect instanceof Lighting) {
            input = ((Lighting)effect).getBumpInput();
        } else if (effect instanceof MotionBlur) {
            input = ((MotionBlur)effect).getInput();
        } else if (effect instanceof PerspectiveTransform) {
            input = ((PerspectiveTransform)effect).getInput();
        } else if (effect instanceof Reflection) {
            input = ((Reflection)effect).getInput();
        } else if (effect instanceof SepiaTone) {
            input = ((SepiaTone)effect).getInput();
        } else if (effect instanceof Shadow) {
            input = ((Shadow)effect).getInput();
        } else {
            assert (false);
            input = null;
        }
        return input;
    }

    static void setDefaultInput(Effect effect, Effect input) {
        assert (effect != null);
        if (effect instanceof Blend) {
            ((Blend)effect).setTopInput(input);
        } else if (effect instanceof Bloom) {
            ((Bloom)effect).setInput(input);
        } else if (effect instanceof BoxBlur) {
            ((BoxBlur)effect).setInput(input);
        } else if (effect instanceof ColorAdjust) {
            ((ColorAdjust)effect).setInput(input);
        } else if (!(effect instanceof ColorInput)) {
            if (effect instanceof DisplacementMap) {
                ((DisplacementMap)effect).setInput(input);
            } else if (effect instanceof DropShadow) {
                ((DropShadow)effect).setInput(input);
            } else if (effect instanceof GaussianBlur) {
                ((GaussianBlur)effect).setInput(input);
            } else if (effect instanceof Glow) {
                ((Glow)effect).setInput(input);
            } else if (!(effect instanceof ImageInput)) {
                if (effect instanceof InnerShadow) {
                    ((InnerShadow)effect).setInput(input);
                } else if (effect instanceof Lighting) {
                    ((Lighting)effect).setBumpInput(input);
                } else if (effect instanceof MotionBlur) {
                    ((MotionBlur)effect).setInput(input);
                } else if (effect instanceof PerspectiveTransform) {
                    ((PerspectiveTransform)effect).setInput(input);
                } else if (effect instanceof Reflection) {
                    ((Reflection)effect).setInput(input);
                } else if (effect instanceof SepiaTone) {
                    ((SepiaTone)effect).setInput(input);
                } else if (effect instanceof Shadow) {
                    ((Shadow)effect).setInput(input);
                } else assert (false);
            }
        }
    }

    public static double clamp(double min, double value, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }
}

