/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.editors;

import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.EffectPickerController;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.editors.DoubleTextFieldControl;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.editors.EnumControl;
import com.oracle.javafx.scenebuilder.kit.util.control.effectpicker.editors.SliderControl;
import com.oracle.javafx.scenebuilder.kit.util.control.paintpicker.PaintPicker;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.effect.Light;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class LightControl
extends VBox {
    @FXML
    private Label lightLabel;
    @FXML
    private ChoiceBox<LightsEnum> lightChoiceBox;
    @FXML
    private VBox lightProperties;
    private final ObjectProperty<Light> value = new SimpleObjectProperty();
    private final EffectPickerController effectPickerController;
    private PaintPicker colorPicker;
    private final Light defaultDistant;
    private final Light defaultPoint;
    private final Light defaultSpot;
    private final BooleanProperty liveUpdate = new SimpleBooleanProperty();

    public LightControl(EffectPickerController effectPickerController, String label, Light initValue) {
        this.effectPickerController = effectPickerController;
        this.defaultDistant = new Light.Distant();
        this.defaultPoint = new Light.Point();
        this.defaultSpot = new Light.Spot();
        this.initialize(label, initValue);
    }

    public ObjectProperty<Light> valueProperty() {
        return this.value;
    }

    public Light getValue() {
        return (Light)this.value.get();
    }

    public void setValue(Light v) {
        this.value.set((Object)v);
    }

    public final BooleanProperty liveUpdateProperty() {
        return this.liveUpdate;
    }

    public boolean isLiveUpdate() {
        return this.liveUpdate.get();
    }

    public void setLiveUpdate(boolean value) {
        this.liveUpdate.setValue(Boolean.valueOf(value));
    }

    private void initialize(String label, Light initValue) {
        URL layoutURL = EnumControl.class.getResource("LightControl.fxml");
        try (InputStream is = layoutURL.openStream();){
            FXMLLoader loader = new FXMLLoader();
            loader.setController((Object)this);
            loader.setRoot((Object)this);
            loader.setLocation(layoutURL);
            Parent p = (Parent)loader.load(is);
            assert (p == this);
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
        this.lightLabel.setText(label);
        this.lightChoiceBox.getItems().addAll((Object[])LightsEnum.values());
        this.setValue(initValue);
        if (initValue == null) {
            this.lightChoiceBox.setValue((Object)LightsEnum.NONE);
        } else if (initValue instanceof Light.Distant) {
            this.lightChoiceBox.setValue((Object)LightsEnum.DISTANT);
        } else if (initValue instanceof Light.Point) {
            this.lightChoiceBox.setValue((Object)LightsEnum.POINT);
        } else {
            assert (initValue instanceof Light.Spot);
            this.lightChoiceBox.setValue((Object)LightsEnum.SPOT);
        }
        this.lightChoiceBox.getSelectionModel().selectedItemProperty().addListener((ov, oldValue, newValue) -> {
            Light light;
            switch (newValue.ordinal()) {
                case 0: {
                    light = this.defaultDistant;
                    break;
                }
                case 1: {
                    light = this.defaultPoint;
                    break;
                }
                case 2: {
                    light = this.defaultSpot;
                    break;
                }
                case 3: {
                    light = null;
                    break;
                }
                default: {
                    light = null;
                    assert (false);
                    break;
                }
            }
            this.setValue(light);
            this.updateLightPropertiesUI();
            this.effectPickerController.incrementRevision();
        });
        this.lightChoiceBox.addEventHandler(ActionEvent.ACTION, event -> event.consume());
        this.updateLightPropertiesUI();
    }

    private void updateLightPropertiesUI() {
        this.lightProperties.getChildren().clear();
        if (this.getValue() != null) {
            this.lightProperties.getChildren().add((Object)this.getColorPicker());
            this.colorPicker.setPaintProperty((Paint)this.getValue().getColor());
            if (this.getValue() instanceof Light.Distant) {
                Light.Distant distant = (Light.Distant)this.getValue();
                SliderControl azimuthEditor = new SliderControl(this.effectPickerController, "azimuth", 0.0, 360.0, distant.getAzimuth(), 1.0, false);
                distant.azimuthProperty().bind((ObservableValue)azimuthEditor.valueProperty());
                this.lightProperties.getChildren().add((Object)azimuthEditor);
                SliderControl elevationEditor = new SliderControl(this.effectPickerController, "elevation", 0.0, 360.0, distant.getElevation(), 1.0, false);
                distant.elevationProperty().bind((ObservableValue)elevationEditor.valueProperty());
                this.lightProperties.getChildren().add((Object)elevationEditor);
            } else {
                assert (this.getValue() instanceof Light.Point);
                Light.Point point = (Light.Point)this.getValue();
                DoubleTextFieldControl xEditor = new DoubleTextFieldControl(this.effectPickerController, "x", -10.0, 10.0, point.getX(), 1.0);
                point.xProperty().bind((ObservableValue)xEditor.valueProperty());
                this.lightProperties.getChildren().add((Object)xEditor);
                DoubleTextFieldControl yEditor = new DoubleTextFieldControl(this.effectPickerController, "y", -10.0, 10.0, point.getY(), 1.0);
                point.yProperty().bind((ObservableValue)yEditor.valueProperty());
                this.lightProperties.getChildren().add((Object)yEditor);
                DoubleTextFieldControl zEditor = new DoubleTextFieldControl(this.effectPickerController, "z", -10.0, 10.0, point.getY(), 1.0);
                point.zProperty().bind((ObservableValue)zEditor.valueProperty());
                this.lightProperties.getChildren().add((Object)zEditor);
                if (point instanceof Light.Spot) {
                    Light.Spot spot = (Light.Spot)this.getValue();
                    DoubleTextFieldControl pointsAtXEditor = new DoubleTextFieldControl(this.effectPickerController, "pointsAtX", -10.0, 10.0, spot.getPointsAtX(), 1.0);
                    spot.pointsAtXProperty().bind((ObservableValue)pointsAtXEditor.valueProperty());
                    this.lightProperties.getChildren().add((Object)pointsAtXEditor);
                    DoubleTextFieldControl pointsAtYEditor = new DoubleTextFieldControl(this.effectPickerController, "pointsAtY", -10.0, 10.0, spot.getPointsAtY(), 1.0);
                    spot.pointsAtYProperty().bind((ObservableValue)pointsAtYEditor.valueProperty());
                    this.lightProperties.getChildren().add((Object)pointsAtYEditor);
                    DoubleTextFieldControl pointsAtZEditor = new DoubleTextFieldControl(this.effectPickerController, "pointsAtZ", -10.0, 10.0, spot.getPointsAtZ(), 1.0);
                    spot.pointsAtZProperty().bind((ObservableValue)pointsAtZEditor.valueProperty());
                    this.lightProperties.getChildren().add((Object)pointsAtZEditor);
                    SliderControl specularExponentEditor = new SliderControl(this.effectPickerController, "specularExponent", 0.0, 4.0, spot.getSpecularExponent(), 1.0, false);
                    spot.specularExponentProperty().bind((ObservableValue)specularExponentEditor.valueProperty());
                    this.lightProperties.getChildren().add((Object)specularExponentEditor);
                }
            }
        }
    }

    private PaintPicker getColorPicker() {
        if (this.colorPicker == null) {
            this.colorPicker = new PaintPicker(this.effectPickerController.getPaintPickerDelegate(), PaintPicker.Mode.COLOR);
            this.colorPicker.paintProperty().addListener((ov, oldValue, newValue) -> {
                assert (newValue instanceof Color);
                Color color = (Color)newValue;
                this.getValue().setColor(color);
                this.effectPickerController.incrementRevision();
            });
            this.colorPicker.liveUpdateProperty().addListener((ov, oldValue, newValue) -> this.setLiveUpdate((boolean)newValue));
        }
        return this.colorPicker;
    }

    private static enum LightsEnum {
        DISTANT,
        POINT,
        SPOT,
        NONE;

    }
}

