/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.util.control.paintpicker.gradientpicker;

import com.oracle.javafx.scenebuilder.kit.util.control.paintpicker.PaintPicker;
import com.oracle.javafx.scenebuilder.kit.util.control.paintpicker.PaintPickerController;
import com.oracle.javafx.scenebuilder.kit.util.control.paintpicker.gradientpicker.GradientPickerStop;
import com.oracle.javafx.scenebuilder.kit.util.control.paintpicker.rotator.RotatorControl;
import com.oracle.javafx.scenebuilder.kit.util.control.paintpicker.slider.SliderControl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;

public class GradientPicker
extends VBox {
    @FXML
    private Pane track_pane;
    @FXML
    private Label stop_label;
    @FXML
    private Rectangle preview_rect;
    @FXML
    private StackPane slider_container;
    @FXML
    private VBox radial_container;
    @FXML
    private VBox shared_container;
    @FXML
    private Slider startX_slider;
    @FXML
    private Slider endX_slider;
    @FXML
    private Slider startY_slider;
    @FXML
    private Slider endY_slider;
    @FXML
    private Slider centerX_slider;
    @FXML
    private Slider centerY_slider;
    @FXML
    private CheckBox proportional_checkbox;
    @FXML
    private ChoiceBox<CycleMethod> cycleMethod_choicebox;
    private final PaintPickerController paintPicker;
    private final RotatorControl focusAngleRotator = new RotatorControl("focusAngle");
    private final SliderControl focusDistanceSlider = new SliderControl("focusDistance", -1.0, 1.0, 0.0);
    private final SliderControl radiusSlider = new SliderControl("radius", 0.0, 1.0, 0.5);
    private final List<GradientPickerStop> gradientPickerStops = new ArrayList<GradientPickerStop>();
    private final int maxStops = 12;

    public GradientPicker(PaintPickerController pe) {
        this.paintPicker = pe;
        this.initialize();
    }

    public final PaintPickerController getPaintPickerController() {
        return this.paintPicker;
    }

    public Paint getValue(PaintPicker.Mode mode) {
        return switch (mode) {
            case PaintPicker.Mode.LINEAR -> {
                double startX = this.startX_slider.getValue();
                double startY = this.startY_slider.getValue();
                double endX = this.endX_slider.getValue();
                double endY = this.endY_slider.getValue();
                boolean linear_proportional = this.proportional_checkbox.isSelected();
                CycleMethod linear_cycleMethod = (CycleMethod)this.cycleMethod_choicebox.getValue();
                yield new LinearGradient(startX, startY, endX, endY, linear_proportional, linear_cycleMethod, this.getStops());
            }
            case PaintPicker.Mode.RADIAL -> {
                double focusAngle = this.focusAngleRotator.getRotationProperty();
                double focusDistance = this.focusDistanceSlider.getSlider().getValue();
                double centerX = this.centerX_slider.getValue();
                double centerY = this.centerY_slider.getValue();
                double radius = this.radiusSlider.getSlider().getValue();
                boolean radial_proportional = this.proportional_checkbox.isSelected();
                CycleMethod radial_cycleMethod = (CycleMethod)this.cycleMethod_choicebox.getValue();
                yield new RadialGradient(focusAngle, focusDistance, centerX, centerY, radius, radial_proportional, radial_cycleMethod, this.getStops());
            }
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                yield null;
            }
        };
    }

    public boolean isGradientStopsEmpty() {
        return this.gradientPickerStops.isEmpty();
    }

    public List<GradientPickerStop> getGradientStops() {
        return this.gradientPickerStops;
    }

    public GradientPickerStop getSelectedStop() {
        GradientPickerStop selectedThumb = null;
        for (GradientPickerStop gradientStopThumb : this.gradientPickerStops) {
            if (!gradientStopThumb.isSelected()) continue;
            selectedThumb = gradientStopThumb;
        }
        return selectedThumb;
    }

    public void updateUI(Paint value) {
        assert (value instanceof LinearGradient || value instanceof RadialGradient);
        if (value instanceof LinearGradient) {
            LinearGradient linear = (LinearGradient)value;
            this.startX_slider.setValue(linear.getStartX());
            this.startY_slider.setValue(linear.getStartY());
            this.endX_slider.setValue(linear.getEndX());
            this.endY_slider.setValue(linear.getEndY());
            this.proportional_checkbox.setSelected(linear.isProportional());
            this.cycleMethod_choicebox.setValue((Object)linear.getCycleMethod());
            this.removeAllStops();
            for (Stop stop : linear.getStops()) {
                this.addStop(0.0, 1.0, stop.getOffset(), stop.getColor());
            }
        } else {
            assert (value instanceof RadialGradient);
            RadialGradient radial = (RadialGradient)value;
            this.centerX_slider.setValue(radial.getCenterX());
            this.centerY_slider.setValue(radial.getCenterY());
            this.focusAngleRotator.setRotationProperty(radial.getFocusAngle());
            this.focusDistanceSlider.getSlider().setValue(radial.getFocusDistance());
            this.radiusSlider.getSlider().setValue(radial.getRadius());
            this.proportional_checkbox.setSelected(radial.isProportional());
            this.cycleMethod_choicebox.setValue((Object)radial.getCycleMethod());
            this.removeAllStops();
            for (Stop stop : radial.getStops()) {
                this.addStop(0.0, 1.0, stop.getOffset(), stop.getColor());
            }
        }
        this.setMode(value);
        this.updatePreview(value);
    }

    public void updatePreview(Paint value) {
        this.preview_rect.setFill(value);
    }

    public void setMode(Paint value) {
        PaintPicker.Mode mode;
        if (value instanceof LinearGradient) {
            mode = PaintPicker.Mode.LINEAR;
        } else {
            assert (value instanceof RadialGradient);
            mode = PaintPicker.Mode.RADIAL;
        }
        this.startX_slider.setVisible(mode == PaintPicker.Mode.LINEAR);
        this.startY_slider.setVisible(mode == PaintPicker.Mode.LINEAR);
        this.endX_slider.setVisible(mode == PaintPicker.Mode.LINEAR);
        this.endY_slider.setVisible(mode == PaintPicker.Mode.LINEAR);
        this.centerX_slider.setVisible(mode == PaintPicker.Mode.RADIAL);
        this.centerY_slider.setVisible(mode == PaintPicker.Mode.RADIAL);
        this.radial_container.setVisible(mode == PaintPicker.Mode.RADIAL);
        this.radial_container.setManaged(mode == PaintPicker.Mode.RADIAL);
    }

    private void initialize() {
        FXMLLoader loader = new FXMLLoader();
        loader.setLocation(GradientPicker.class.getResource("GradientPicker.fxml"));
        loader.setController((Object)this);
        loader.setRoot((Object)this);
        try {
            loader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(GradientPicker.class.getName()).log(Level.SEVERE, null, ex);
        }
        assert (this.proportional_checkbox != null);
        assert (this.cycleMethod_choicebox != null);
        assert (this.startX_slider != null);
        assert (this.endX_slider != null);
        assert (this.startY_slider != null);
        assert (this.endY_slider != null);
        assert (this.centerX_slider != null);
        assert (this.centerY_slider != null);
        assert (this.radial_container != null);
        GradientPickerStop black = this.addStop(0.0, 1.0, 0.0, Color.BLACK);
        this.addStop(0.0, 1.0, 1.0, Color.WHITE);
        this.setSelectedStop(black);
        this.proportional_checkbox.setSelected(true);
        this.proportional_checkbox.selectedProperty().addListener((ov, oldValue, newValue) -> {
            PaintPicker.Mode mode = this.paintPicker.getMode();
            Paint value = this.getValue(mode);
            this.preview_rect.setFill(value);
            this.paintPicker.setPaintProperty(value);
        });
        this.proportional_checkbox.setOnAction(event -> event.consume());
        this.cycleMethod_choicebox.setItems(FXCollections.observableArrayList((Object[])CycleMethod.values()));
        this.cycleMethod_choicebox.getSelectionModel().selectFirst();
        this.cycleMethod_choicebox.getSelectionModel().selectedItemProperty().addListener((ov, oldValue, newValue) -> {
            PaintPicker.Mode mode = this.paintPicker.getMode();
            Paint value = this.getValue(mode);
            this.preview_rect.setFill(value);
            this.paintPicker.setPaintProperty(value);
        });
        this.cycleMethod_choicebox.addEventHandler(ActionEvent.ACTION, event -> event.consume());
        ChangeListener onValueChange = (ov, oldValue, newValue) -> {
            PaintPicker.Mode mode = this.paintPicker.getMode();
            Paint value = this.getValue(mode);
            this.preview_rect.setFill(value);
            this.paintPicker.setPaintProperty(value);
        };
        this.startX_slider.valueProperty().addListener(onValueChange);
        this.startY_slider.valueProperty().addListener(onValueChange);
        this.endX_slider.valueProperty().addListener(onValueChange);
        this.endY_slider.valueProperty().addListener(onValueChange);
        this.centerX_slider.valueProperty().addListener(onValueChange);
        this.centerY_slider.valueProperty().addListener(onValueChange);
        this.focusAngleRotator.rotationProperty().addListener(onValueChange);
        this.focusDistanceSlider.getSlider().valueProperty().addListener(onValueChange);
        this.radiusSlider.getSlider().valueProperty().addListener(onValueChange);
        this.radial_container.getChildren().addAll((Object[])new Node[]{this.radiusSlider, this.focusDistanceSlider, this.focusAngleRotator});
        this.radial_container.setVisible(false);
        this.radial_container.setManaged(false);
        ChangeListener liveUpdateListener = (ov, oldValue, newValue) -> this.paintPicker.setLiveUpdate((boolean)newValue);
        this.startX_slider.pressedProperty().addListener(liveUpdateListener);
        this.startY_slider.pressedProperty().addListener(liveUpdateListener);
        this.endX_slider.pressedProperty().addListener(liveUpdateListener);
        this.endY_slider.pressedProperty().addListener(liveUpdateListener);
        this.centerX_slider.pressedProperty().addListener(liveUpdateListener);
        this.centerY_slider.pressedProperty().addListener(liveUpdateListener);
        this.radiusSlider.pressedProperty().addListener(liveUpdateListener);
        this.focusDistanceSlider.pressedProperty().addListener(liveUpdateListener);
        this.focusAngleRotator.pressedProperty().addListener(liveUpdateListener);
        this.slider_container.pressedProperty().addListener(liveUpdateListener);
    }

    @FXML
    void sliderPressed(MouseEvent event) {
        double percentH = 100.0 / this.track_pane.getWidth() * event.getX() / 100.0;
        Color color = this.paintPicker.getColorPicker().getValue();
        this.addStop(0.0, 1.0, percentH, color);
        PaintPicker.Mode mode = this.paintPicker.getMode();
        Paint value = this.getValue(mode);
        this.preview_rect.setFill(value);
        this.paintPicker.setPaintProperty(value);
    }

    @FXML
    void sliderDragged(MouseEvent event) {
        PaintPicker.Mode mode = this.paintPicker.getMode();
        Paint value = this.getValue(mode);
        this.preview_rect.setFill(value);
        this.paintPicker.setPaintProperty(value);
    }

    GradientPickerStop addStop(double min, double max, double value, Color color) {
        if (this.gradientPickerStops.size() < 12) {
            GradientPickerStop gradientStop = new GradientPickerStop(this, min, max, value, color);
            this.track_pane.getChildren().add((Object)gradientStop);
            this.gradientPickerStops.add(gradientStop);
            return gradientStop;
        }
        return null;
    }

    void removeStop(GradientPickerStop gradientStop) {
        this.track_pane.getChildren().remove((Object)gradientStop);
        this.gradientPickerStops.remove((Object)gradientStop);
    }

    void removeAllStops() {
        this.track_pane.getChildren().clear();
        this.gradientPickerStops.clear();
    }

    public void setSelectedStop(GradientPickerStop gradientStop) {
        for (GradientPickerStop stop : this.gradientPickerStops) {
            stop.setSelected(false);
        }
        if (gradientStop != null) {
            gradientStop.setSelected(true);
        }
    }

    private List<Stop> getStops() {
        ArrayList<Stop> stops = new ArrayList<Stop>();
        for (GradientPickerStop ges : this.getGradientStops()) {
            Stop stop = new Stop(ges.getOffset(), ges.getColor());
            stops.add(stop);
        }
        return stops;
    }
}

