/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.util.eventnames;

import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

public class FindEventNamesUtil {
    private static Map<String, String> events = new TreeMap<String, String>();

    private FindEventNamesUtil() {
    }

    public static void initializeEventsMap() {
        FindEventNamesUtil.loadEventsInMap();
    }

    public static String findEventName(String eventType) {
        return Optional.ofNullable(events.get(eventType)).orElse("ActionEvent");
    }

    private static void loadEventsInMap() {
        FindEventNamesUtil.loadMainEvents();
        FindEventNamesUtil.loadDragDropEvents();
        FindEventNamesUtil.loadKeyboardEvents();
        FindEventNamesUtil.loadMouseEvents();
        FindEventNamesUtil.loadRotationEvents();
        FindEventNamesUtil.loadSwipeEvents();
        FindEventNamesUtil.loadTouchEvents();
        FindEventNamesUtil.loadZoomEvents();
    }

    private static void loadMainEvents() {
        events.put("onAction", "ActionEvent");
    }

    private static void loadDragDropEvents() {
        events.put("onDragDetected", "MouseEvent");
        events.put("onDragDone", "DragEvent");
        events.put("onDragDropped", "DragEvent");
        events.put("onDragEntered", "DragEvent");
        events.put("onDragExited", "DragEvent");
        events.put("onDragOver", "DragEvent");
        events.put("onMouseDragEntered", "MouseDragEvent");
        events.put("onMouseDragExited", "MouseDragEvent");
        events.put("onMouseDragOver", "MouseDragEvent");
        events.put("onMouseDragReleased", "MouseDragEvent");
    }

    private static void loadKeyboardEvents() {
        events.put("onInputMethodTextChanged", "InputMethodEvent");
        events.put("onKeyPressed", "KeyEvent");
        events.put("onKeyReleased", "KeyEvent");
        events.put("onKeyTyped", "KeyEvent");
    }

    private static void loadMouseEvents() {
        events.put("onContextMenuRequested", "ContextMenuEvent");
        events.put("onMouseClicked", "MouseEvent");
        events.put("onMouseDragged", "MouseEvent");
        events.put("onMouseEntered", "MouseEvent");
        events.put("onMouseExited", "MouseEvent");
        events.put("onMouseMoved", "MouseEvent");
        events.put("onMousePressed", "MouseEvent");
        events.put("onMouseReleased", "MouseEvent");
        events.put("onScroll", "ScrollEvent");
        events.put("onScrollStarted", "ScrollEvent");
        events.put("onScrollFinished", "ScrollEvent");
    }

    private static void loadRotationEvents() {
        events.put("onRotate", "RotateEvent");
        events.put("onRotationFinished", "RotateEvent");
        events.put("onRotationStarted", "RotateEvent");
    }

    private static void loadSwipeEvents() {
        events.put("onSwipeLeft", "SwipeEvent");
        events.put("onSwipeRight", "SwipeEvent");
        events.put("onSwipeUp", "SwipeEvent");
        events.put("onSwipeDown", "SwipeEvent");
    }

    private static void loadTouchEvents() {
        events.put("onTouchMoved", "TouchEvent");
        events.put("onTouchPressed", "TouchEvent");
        events.put("onTouchReleased", "TouchEvent");
        events.put("onTouchStationary", "TouchEvent");
    }

    private static void loadZoomEvents() {
        events.put("onZoom", "ZoomEvent");
        events.put("onZoomStarted", "ZoomEvent");
        events.put("onZoomFinished", "ZoomEvent");
    }
}

