/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.Scope;
import org.apache.maven.api.annotations.Experimental;

@Experimental
public enum ResolutionScope {
    PROJECT_COMPILE("project-compile", Scope.EMPTY, Scope.COMPILE_ONLY, Scope.COMPILE, Scope.PROVIDED),
    PROJECT_RUNTIME("project-runtime", Scope.EMPTY, Scope.COMPILE, Scope.RUNTIME),
    TEST_COMPILE("test-compile", Scope.EMPTY, Scope.COMPILE_ONLY, Scope.COMPILE, Scope.PROVIDED, Scope.TEST_COMPILE_ONLY, Scope.TEST),
    TEST_RUNTIME("test-runtime", Scope.EMPTY, Scope.COMPILE, Scope.RUNTIME, Scope.PROVIDED, Scope.TEST, Scope.TEST_RUNTIME);

    private static final Map<String, ResolutionScope> VALUES;
    private final String id;
    private final Set<Scope> scopes;

    public static ResolutionScope fromString(String id) {
        return Optional.ofNullable(VALUES.get(id)).orElseThrow(() -> new IllegalArgumentException("Unknown resolution scope " + id));
    }

    private ResolutionScope(String id, Scope ... scopes) {
        this.id = id;
        this.scopes = Collections.unmodifiableSet(new HashSet<Scope>(Arrays.asList(scopes)));
    }

    public String id() {
        return this.id;
    }

    public Set<Scope> scopes() {
        return this.scopes;
    }

    static {
        VALUES = Stream.of(ResolutionScope.values()).collect(Collectors.toMap(ResolutionScope::id, s -> s));
    }
}

