/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ConfigurationContainer;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.xml.XmlNode;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class PluginExecution
extends ConfigurationContainer
implements Serializable,
InputLocationTracker {
    final String id;
    final String phase;
    final int priority;
    final List<String> goals;
    public static final String DEFAULT_EXECUTION_ID = "default";

    PluginExecution(String inherited, XmlNode configuration, String id, String phase, int priority, Collection<String> goals, Map<Object, InputLocation> locations) {
        super(inherited, configuration, locations);
        this.id = id;
        this.phase = phase;
        this.priority = priority;
        this.goals = ImmutableCollections.copy(goals);
    }

    public String getId() {
        return this.id;
    }

    public String getPhase() {
        return this.phase;
    }

    public int getPriority() {
        return this.priority;
    }

    @Nonnull
    public List<String> getGoals() {
        return this.goals;
    }

    @Override
    @Nonnull
    public Builder with() {
        return PluginExecution.newBuilder(this);
    }

    @Override
    @Nonnull
    public PluginExecution withInherited(String inherited) {
        return PluginExecution.newBuilder(this, true).inherited(inherited).build();
    }

    @Override
    @Nonnull
    public PluginExecution withConfiguration(XmlNode configuration) {
        return PluginExecution.newBuilder(this, true).configuration(configuration).build();
    }

    @Nonnull
    public PluginExecution withId(String id) {
        return PluginExecution.newBuilder(this, true).id(id).build();
    }

    @Nonnull
    public PluginExecution withPhase(String phase) {
        return PluginExecution.newBuilder(this, true).phase(phase).build();
    }

    @Nonnull
    public PluginExecution withPriority(int priority) {
        return PluginExecution.newBuilder(this, true).priority(priority).build();
    }

    @Nonnull
    public PluginExecution withGoals(Collection<String> goals) {
        return PluginExecution.newBuilder(this, true).goals(goals).build();
    }

    @Nonnull
    public static PluginExecution newInstance() {
        return PluginExecution.newInstance(true);
    }

    @Nonnull
    public static PluginExecution newInstance(boolean withDefaults) {
        return PluginExecution.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return PluginExecution.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(PluginExecution from) {
        return PluginExecution.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(PluginExecution from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public String toString() {
        return this.getId();
    }

    @NotThreadSafe
    public static class Builder
    extends ConfigurationContainer.Builder {
        PluginExecution base;
        String id;
        String phase;
        Integer priority;
        Collection<String> goals;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.id = PluginExecution.DEFAULT_EXECUTION_ID;
                this.priority = 0;
            }
        }

        Builder(PluginExecution base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.id = base.id;
                this.phase = base.phase;
                this.priority = base.priority;
                this.goals = base.goals;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder inherited(String inherited) {
            this.inherited = inherited;
            return this;
        }

        @Override
        @Nonnull
        public Builder configuration(XmlNode configuration) {
            this.configuration = configuration;
            return this;
        }

        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder phase(String phase) {
            this.phase = phase;
            return this;
        }

        @Nonnull
        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        @Nonnull
        public Builder goals(Collection<String> goals) {
            this.goals = goals;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public PluginExecution build() {
            if (!(this.base == null || this.inherited != null && this.inherited != this.base.inherited || this.configuration != null && this.configuration != this.base.configuration || this.id != null && this.id != this.base.id || this.phase != null && this.phase != this.base.phase || this.priority != null && this.priority != this.base.priority || this.goals != null && this.goals != this.base.goals)) {
                return this.base;
            }
            Map newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            HashMap<Object, InputLocation> locations = new HashMap<Object, InputLocation>();
            locations.put("", newlocs.containsKey("") ? (InputLocation)newlocs.get("") : (InputLocation)oldlocs.get(""));
            locations.put("inherited", newlocs.containsKey("inherited") ? (InputLocation)newlocs.get("inherited") : (InputLocation)oldlocs.get("inherited"));
            locations.put("configuration", newlocs.containsKey("configuration") ? (InputLocation)newlocs.get("configuration") : (InputLocation)oldlocs.get("configuration"));
            locations.put("id", newlocs.containsKey("id") ? (InputLocation)newlocs.get("id") : (InputLocation)oldlocs.get("id"));
            locations.put("phase", newlocs.containsKey("phase") ? (InputLocation)newlocs.get("phase") : (InputLocation)oldlocs.get("phase"));
            locations.put("priority", newlocs.containsKey("priority") ? (InputLocation)newlocs.get("priority") : (InputLocation)oldlocs.get("priority"));
            locations.put("goals", newlocs.containsKey("goals") ? (InputLocation)newlocs.get("goals") : (InputLocation)oldlocs.get("goals"));
            return new PluginExecution(this.inherited != null ? this.inherited : (this.base != null ? this.base.inherited : null), this.configuration != null ? this.configuration : (this.base != null ? this.base.configuration : null), this.id != null ? this.id : (this.base != null ? this.base.id : null), this.phase != null ? this.phase : (this.base != null ? this.base.phase : null), this.priority != null ? this.priority : (this.base != null ? this.base.priority : 0), this.goals != null ? this.goals : (this.base != null ? this.base.goals : null), locations);
        }
    }
}

