/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.plugin.descriptor;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.plugin.descriptor.ImmutableCollections;
import org.apache.maven.api.plugin.descriptor.MojoDescriptor;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class PluginDescriptor
implements Serializable {
    final String namespaceUri;
    final String modelEncoding;
    final String name;
    final String description;
    final String groupId;
    final String artifactId;
    final String version;
    final String goalPrefix;
    final boolean isolatedRealm;
    final boolean inheritedByDefault;
    final String requiredJavaVersion;
    final String requiredMavenVersion;
    final List<MojoDescriptor> mojos;

    PluginDescriptor(String namespaceUri, String modelEncoding, String name, String description, String groupId, String artifactId, String version, String goalPrefix, boolean isolatedRealm, boolean inheritedByDefault, String requiredJavaVersion, String requiredMavenVersion, Collection<MojoDescriptor> mojos) {
        this.namespaceUri = namespaceUri;
        this.modelEncoding = modelEncoding;
        this.name = name;
        this.description = description;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.goalPrefix = goalPrefix;
        this.isolatedRealm = isolatedRealm;
        this.inheritedByDefault = inheritedByDefault;
        this.requiredJavaVersion = requiredJavaVersion;
        this.requiredMavenVersion = requiredMavenVersion;
        this.mojos = ImmutableCollections.copy(mojos);
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getGoalPrefix() {
        return this.goalPrefix;
    }

    public boolean isIsolatedRealm() {
        return this.isolatedRealm;
    }

    public boolean isInheritedByDefault() {
        return this.inheritedByDefault;
    }

    public String getRequiredJavaVersion() {
        return this.requiredJavaVersion;
    }

    public String getRequiredMavenVersion() {
        return this.requiredMavenVersion;
    }

    @Nonnull
    public List<MojoDescriptor> getMojos() {
        return this.mojos;
    }

    @Nonnull
    public Builder with() {
        return PluginDescriptor.newBuilder(this);
    }

    @Nonnull
    public PluginDescriptor withName(String name) {
        return PluginDescriptor.newBuilder(this, true).name(name).build();
    }

    @Nonnull
    public PluginDescriptor withDescription(String description) {
        return PluginDescriptor.newBuilder(this, true).description(description).build();
    }

    @Nonnull
    public PluginDescriptor withGroupId(String groupId) {
        return PluginDescriptor.newBuilder(this, true).groupId(groupId).build();
    }

    @Nonnull
    public PluginDescriptor withArtifactId(String artifactId) {
        return PluginDescriptor.newBuilder(this, true).artifactId(artifactId).build();
    }

    @Nonnull
    public PluginDescriptor withVersion(String version) {
        return PluginDescriptor.newBuilder(this, true).version(version).build();
    }

    @Nonnull
    public PluginDescriptor withGoalPrefix(String goalPrefix) {
        return PluginDescriptor.newBuilder(this, true).goalPrefix(goalPrefix).build();
    }

    @Nonnull
    public PluginDescriptor withIsolatedRealm(boolean isolatedRealm) {
        return PluginDescriptor.newBuilder(this, true).isolatedRealm(isolatedRealm).build();
    }

    @Nonnull
    public PluginDescriptor withInheritedByDefault(boolean inheritedByDefault) {
        return PluginDescriptor.newBuilder(this, true).inheritedByDefault(inheritedByDefault).build();
    }

    @Nonnull
    public PluginDescriptor withRequiredJavaVersion(String requiredJavaVersion) {
        return PluginDescriptor.newBuilder(this, true).requiredJavaVersion(requiredJavaVersion).build();
    }

    @Nonnull
    public PluginDescriptor withRequiredMavenVersion(String requiredMavenVersion) {
        return PluginDescriptor.newBuilder(this, true).requiredMavenVersion(requiredMavenVersion).build();
    }

    @Nonnull
    public PluginDescriptor withMojos(Collection<MojoDescriptor> mojos) {
        return PluginDescriptor.newBuilder(this, true).mojos(mojos).build();
    }

    @Nonnull
    public static PluginDescriptor newInstance() {
        return PluginDescriptor.newInstance(true);
    }

    @Nonnull
    public static PluginDescriptor newInstance(boolean withDefaults) {
        return PluginDescriptor.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return PluginDescriptor.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(PluginDescriptor from) {
        return PluginDescriptor.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(PluginDescriptor from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public String getPluginLookupKey() {
        return this.groupId + ":" + this.artifactId;
    }

    public String getId() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }

    @NotThreadSafe
    public static class Builder {
        PluginDescriptor base;
        String namespaceUri;
        String modelEncoding;
        String name;
        String description;
        String groupId;
        String artifactId;
        String version;
        String goalPrefix;
        Boolean isolatedRealm;
        Boolean inheritedByDefault;
        String requiredJavaVersion;
        String requiredMavenVersion;
        Collection<MojoDescriptor> mojos;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                this.isolatedRealm = false;
                this.inheritedByDefault = true;
            }
        }

        Builder(PluginDescriptor base, boolean forceCopy) {
            this.namespaceUri = base.namespaceUri;
            this.modelEncoding = base.modelEncoding;
            if (forceCopy) {
                this.name = base.name;
                this.description = base.description;
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.version = base.version;
                this.goalPrefix = base.goalPrefix;
                this.isolatedRealm = base.isolatedRealm;
                this.inheritedByDefault = base.inheritedByDefault;
                this.requiredJavaVersion = base.requiredJavaVersion;
                this.requiredMavenVersion = base.requiredMavenVersion;
                this.mojos = base.mojos;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder namespaceUri(String namespaceUri) {
            this.namespaceUri = namespaceUri;
            return this;
        }

        @Nonnull
        public Builder modelEncoding(String modelEncoding) {
            this.modelEncoding = modelEncoding;
            return this;
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder description(String description) {
            this.description = description;
            return this;
        }

        @Nonnull
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder goalPrefix(String goalPrefix) {
            this.goalPrefix = goalPrefix;
            return this;
        }

        @Nonnull
        public Builder isolatedRealm(boolean isolatedRealm) {
            this.isolatedRealm = isolatedRealm;
            return this;
        }

        @Nonnull
        public Builder inheritedByDefault(boolean inheritedByDefault) {
            this.inheritedByDefault = inheritedByDefault;
            return this;
        }

        @Nonnull
        public Builder requiredJavaVersion(String requiredJavaVersion) {
            this.requiredJavaVersion = requiredJavaVersion;
            return this;
        }

        @Nonnull
        public Builder requiredMavenVersion(String requiredMavenVersion) {
            this.requiredMavenVersion = requiredMavenVersion;
            return this;
        }

        @Nonnull
        public Builder mojos(Collection<MojoDescriptor> mojos) {
            this.mojos = mojos;
            return this;
        }

        @Nonnull
        public PluginDescriptor build() {
            if (!(this.base == null || this.name != null && this.name != this.base.name || this.description != null && this.description != this.base.description || this.groupId != null && this.groupId != this.base.groupId || this.artifactId != null && this.artifactId != this.base.artifactId || this.version != null && this.version != this.base.version || this.goalPrefix != null && this.goalPrefix != this.base.goalPrefix || this.isolatedRealm != null && this.isolatedRealm != this.base.isolatedRealm || this.inheritedByDefault != null && this.inheritedByDefault != this.base.inheritedByDefault || this.requiredJavaVersion != null && this.requiredJavaVersion != this.base.requiredJavaVersion || this.requiredMavenVersion != null && this.requiredMavenVersion != this.base.requiredMavenVersion || this.mojos != null && this.mojos != this.base.mojos)) {
                return this.base;
            }
            return new PluginDescriptor(this.namespaceUri != null ? this.namespaceUri : (this.base != null ? this.base.namespaceUri : ""), this.modelEncoding != null ? this.modelEncoding : (this.base != null ? this.base.modelEncoding : "UTF-8"), this.name != null ? this.name : (this.base != null ? this.base.name : null), this.description != null ? this.description : (this.base != null ? this.base.description : null), this.groupId != null ? this.groupId : (this.base != null ? this.base.groupId : null), this.artifactId != null ? this.artifactId : (this.base != null ? this.base.artifactId : null), this.version != null ? this.version : (this.base != null ? this.base.version : null), this.goalPrefix != null ? this.goalPrefix : (this.base != null ? this.base.goalPrefix : null), this.isolatedRealm != null ? this.isolatedRealm : (this.base != null ? this.base.isolatedRealm : false), this.inheritedByDefault != null ? this.inheritedByDefault : (this.base != null ? this.base.inheritedByDefault : true), this.requiredJavaVersion != null ? this.requiredJavaVersion : (this.base != null ? this.base.requiredJavaVersion : null), this.requiredMavenVersion != null ? this.requiredMavenVersion : (this.base != null ? this.base.requiredMavenVersion : null), this.mojos != null ? this.mojos : (this.base != null ? this.base.mojos : null));
        }
    }
}

