/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import org.apache.maven.api.ArtifactCoordinate;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.services.BaseRequest;

@Experimental
@Immutable
public interface ArtifactCoordinateFactoryRequest {
    @Nonnull
    public Session getSession();

    public String getGroupId();

    public String getArtifactId();

    public String getVersion();

    public String getClassifier();

    public String getExtension();

    public String getType();

    public String getCoordinateString();

    @Nonnull
    public static ArtifactCoordinateFactoryRequest build(@Nonnull Session session, String groupId, String artifactId, String version, String extension) {
        return ArtifactCoordinateFactoryRequest.builder().session(BaseRequest.nonNull(session, "session")).groupId(groupId).artifactId(artifactId).version(version).extension(extension).build();
    }

    @Nonnull
    public static ArtifactCoordinateFactoryRequest build(@Nonnull Session session, String groupId, String artifactId, String version, String classifier, String extension, String type) {
        return ArtifactCoordinateFactoryRequest.builder().session(BaseRequest.nonNull(session, "session")).groupId(groupId).artifactId(artifactId).version(version).classifier(classifier).extension(extension).type(type).build();
    }

    @Nonnull
    public static ArtifactCoordinateFactoryRequest build(@Nonnull Session session, @Nonnull String coordinateString) {
        return ArtifactCoordinateFactoryRequest.builder().session(BaseRequest.nonNull(session, "session")).coordinateString(BaseRequest.nonNull(coordinateString, "coordinateString")).build();
    }

    @Nonnull
    public static ArtifactCoordinateFactoryRequest build(@Nonnull Session session, @Nonnull ArtifactCoordinate coordinate) {
        return ArtifactCoordinateFactoryRequest.builder().session(BaseRequest.nonNull(session, "session")).groupId(BaseRequest.nonNull(coordinate, "coordinate").getGroupId()).artifactId(coordinate.getArtifactId()).classifier(coordinate.getClassifier()).version(coordinate.getVersion().asString()).extension(coordinate.getExtension()).build();
    }

    public static ArtifactFactoryRequestBuilder builder() {
        return new ArtifactFactoryRequestBuilder();
    }

    @NotThreadSafe
    public static class ArtifactFactoryRequestBuilder {
        private Session session;
        private String groupId;
        private String artifactId;
        private String version;
        private String classifier;
        private String extension;
        private String type;
        private String coordinateString;

        ArtifactFactoryRequestBuilder() {
        }

        public ArtifactFactoryRequestBuilder session(Session session) {
            this.session = session;
            return this;
        }

        public ArtifactFactoryRequestBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public ArtifactFactoryRequestBuilder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public ArtifactFactoryRequestBuilder version(String version) {
            this.version = version;
            return this;
        }

        public ArtifactFactoryRequestBuilder classifier(String classifier) {
            this.classifier = classifier;
            return this;
        }

        public ArtifactFactoryRequestBuilder extension(String extension) {
            this.extension = extension;
            return this;
        }

        public ArtifactFactoryRequestBuilder type(String type) {
            this.type = type;
            return this;
        }

        public ArtifactFactoryRequestBuilder coordinateString(String coordinateString) {
            this.coordinateString = coordinateString;
            return this;
        }

        public ArtifactCoordinateFactoryRequest build() {
            return new DefaultArtifactFactoryRequestArtifact(this.session, this.groupId, this.artifactId, this.version, this.classifier, this.extension, this.type, this.coordinateString);
        }

        private static class DefaultArtifactFactoryRequestArtifact
        extends BaseRequest
        implements ArtifactCoordinateFactoryRequest {
            private final String groupId;
            private final String artifactId;
            private final String version;
            private final String classifier;
            private final String extension;
            private final String type;
            private final String coordinateString;

            DefaultArtifactFactoryRequestArtifact(@Nonnull Session session, String groupId, String artifactId, String version, String classifier, String extension, String type, String coordinateString) {
                super(session);
                this.groupId = groupId;
                this.artifactId = artifactId;
                this.version = version;
                this.classifier = classifier;
                this.extension = extension;
                this.type = type;
                this.coordinateString = coordinateString;
            }

            @Override
            public String getGroupId() {
                return this.groupId;
            }

            @Override
            public String getArtifactId() {
                return this.artifactId;
            }

            @Override
            public String getVersion() {
                return this.version;
            }

            @Override
            public String getClassifier() {
                return this.classifier;
            }

            @Override
            public String getExtension() {
                return this.extension;
            }

            @Override
            public String getType() {
                return this.type;
            }

            @Override
            public String getCoordinateString() {
                return this.coordinateString;
            }
        }
    }
}

