/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.Project;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Service;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.model.Resource;

@Experimental
public interface ProjectManager
extends Service {
    @Nonnull
    public Optional<Path> getPath(Project var1);

    @Nonnull
    public Collection<Artifact> getAttachedArtifacts(Project var1);

    default public void attachArtifact(Session session, Project project, Path path) {
        String name = path.getFileName().toString();
        int dot = name.lastIndexOf(46);
        String ext = dot >= 1 ? name.substring(dot + 1) : "";
        Artifact artifact = session.createArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), ext);
        this.attachArtifact(project, artifact, path);
    }

    default public void attachArtifact(Session session, Project project, String type, Path path) {
        Artifact artifact = session.createArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), null, null, type);
        this.attachArtifact(project, artifact, path);
    }

    public void attachArtifact(Project var1, Artifact var2, Path var3);

    public List<String> getCompileSourceRoots(Project var1);

    public void addCompileSourceRoot(Project var1, String var2);

    public List<String> getTestCompileSourceRoots(Project var1);

    public void addTestCompileSourceRoot(Project var1, String var2);

    public List<Resource> getResources(Project var1);

    public void addResource(Project var1, Resource var2);

    public List<Resource> getTestResources(Project var1);

    public void addTestResource(Project var1, Resource var2);

    public List<RemoteRepository> getRepositories(Project var1);

    public void setProperty(Project var1, String var2, String var3);

    @Nonnull
    public Optional<Project> getExecutionProject(@Nonnull Project var1);
}

