/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.metadata.io;

import com.ctc.wstx.stax.WstxOutputFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.artifact.repository.metadata.v4.Metadata;
import org.apache.maven.artifact.repository.metadata.v4.Plugin;
import org.apache.maven.artifact.repository.metadata.v4.Snapshot;
import org.apache.maven.artifact.repository.metadata.v4.SnapshotVersion;
import org.apache.maven.artifact.repository.metadata.v4.Versioning;
import org.codehaus.stax2.util.StreamWriterDelegate;

@Generated
public class MetadataStaxWriter {
    private static final String NAMESPACE = "http://maven.apache.org/METADATA/1.1.0";
    private static final String SCHEMA_LOCATION = "https://maven.apache.org/xsd/repository-metadata-1.1.0.xsd";
    private String namespace = "http://maven.apache.org/METADATA/1.1.0";
    private String schemaLocation = "https://maven.apache.org/xsd/repository-metadata-1.1.0.xsd";
    private String fileComment = null;

    public void setNamespace(String namespace) {
        this.namespace = Objects.requireNonNull(namespace);
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = Objects.requireNonNull(schemaLocation);
    }

    public void setFileComment(String fileComment) {
        this.fileComment = fileComment;
    }

    public void write(Writer writer, Metadata metadata) throws IOException, XMLStreamException {
        WstxOutputFactory factory = new WstxOutputFactory();
        ((XMLOutputFactory)factory).setProperty("javax.xml.stream.isRepairingNamespaces", false);
        ((XMLOutputFactory)factory).setProperty("com.ctc.wstx.useDoubleQuotesInXmlDecl", true);
        ((XMLOutputFactory)factory).setProperty("com.ctc.wstx.addSpaceAfterEmptyElem", true);
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(((XMLOutputFactory)factory).createXMLStreamWriter(writer));
        serializer.writeStartDocument(metadata.getModelEncoding(), null);
        this.writeMetadata("metadata", metadata, serializer);
        serializer.writeEndDocument();
    }

    public void write(OutputStream stream, Metadata metadata) throws IOException, XMLStreamException {
        WstxOutputFactory factory = new WstxOutputFactory();
        ((XMLOutputFactory)factory).setProperty("javax.xml.stream.isRepairingNamespaces", false);
        ((XMLOutputFactory)factory).setProperty("com.ctc.wstx.useDoubleQuotesInXmlDecl", true);
        ((XMLOutputFactory)factory).setProperty("com.ctc.wstx.addSpaceAfterEmptyElem", true);
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(((XMLOutputFactory)factory).createXMLStreamWriter(stream, metadata.getModelEncoding()));
        serializer.writeStartDocument(metadata.getModelEncoding(), null);
        this.writeMetadata("metadata", metadata, serializer);
        serializer.writeEndDocument();
    }

    private void writeMetadata(String tagName, Metadata metadata, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (metadata != null) {
            if (this.fileComment != null) {
                serializer.writeCharacters("\n");
                serializer.writeComment(this.fileComment);
                serializer.writeCharacters("\n");
            }
            serializer.writeStartElement("", tagName, this.namespace);
            serializer.writeNamespace("", this.namespace);
            serializer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            serializer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", this.namespace + " " + this.schemaLocation);
            this.writeAttr("modelVersion", metadata.getModelVersion(), serializer);
            this.writeTag("groupId", null, metadata.getGroupId(), serializer);
            this.writeTag("artifactId", null, metadata.getArtifactId(), serializer);
            this.writeVersioning("versioning", metadata.getVersioning(), serializer);
            this.writeTag("version", null, metadata.getVersion(), serializer);
            this.writeList("plugins", false, metadata.getPlugins(), serializer, t -> this.writePlugin("plugin", (Plugin)t, serializer));
            serializer.writeEndElement();
        }
    }

    private void writeVersioning(String tagName, Versioning versioning, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (versioning != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("latest", null, versioning.getLatest(), serializer);
            this.writeTag("release", null, versioning.getRelease(), serializer);
            this.writeList("versions", versioning.getVersions(), serializer, t -> this.writeTag("version", null, (String)t, serializer));
            this.writeTag("lastUpdated", null, versioning.getLastUpdated(), serializer);
            this.writeSnapshot("snapshot", versioning.getSnapshot(), serializer);
            this.writeList("snapshotVersions", false, versioning.getSnapshotVersions(), serializer, t -> this.writeSnapshotVersion("snapshotVersion", (SnapshotVersion)t, serializer));
            serializer.writeEndElement();
        }
    }

    private void writeSnapshot(String tagName, Snapshot snapshot, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (snapshot != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("timestamp", null, snapshot.getTimestamp(), serializer);
            this.writeTag("buildNumber", "0", Integer.toString(snapshot.getBuildNumber()), serializer);
            this.writeTag("localCopy", "false", snapshot.isLocalCopy() ? "true" : null, serializer);
            serializer.writeEndElement();
        }
    }

    private void writeSnapshotVersion(String tagName, SnapshotVersion snapshotVersion, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (snapshotVersion != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("classifier", null, snapshotVersion.getClassifier(), serializer);
            this.writeTag("extension", null, snapshotVersion.getExtension(), serializer);
            this.writeTag("value", null, snapshotVersion.getVersion(), serializer);
            this.writeTag("updated", null, snapshotVersion.getUpdated(), serializer);
            serializer.writeEndElement();
        }
    }

    private void writePlugin(String tagName, Plugin plugin, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (plugin != null) {
            serializer.writeStartElement(this.namespace, tagName);
            this.writeTag("name", null, plugin.getName(), serializer);
            this.writeTag("prefix", null, plugin.getPrefix(), serializer);
            this.writeTag("artifactId", null, plugin.getArtifactId(), serializer);
            serializer.writeEndElement();
        }
    }

    private <T> void writeList(String tagName, List<T> list, XMLStreamWriter serializer, ElementWriter<T> writer) throws IOException, XMLStreamException {
        this.writeList(tagName, false, list, serializer, writer);
    }

    private <T> void writeList(String tagName, boolean flat, List<T> list, XMLStreamWriter serializer, ElementWriter<T> writer) throws IOException, XMLStreamException {
        if (list != null && !list.isEmpty()) {
            if (!flat) {
                serializer.writeStartElement(this.namespace, tagName);
            }
            boolean index = false;
            for (T t : list) {
                writer.write(t);
            }
            if (!flat) {
                serializer.writeEndElement();
            }
        }
    }

    private <T> void writeProperties(String tagName, Map<String, String> props, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (props != null && !props.isEmpty()) {
            serializer.writeStartElement(this.namespace, tagName);
            for (Map.Entry<String, String> entry : props.entrySet()) {
                String key = entry.getKey();
                this.writeTag(key, null, entry.getValue(), serializer);
            }
            serializer.writeEndElement();
        }
    }

    private void writeDom(XmlNode dom, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (dom != null) {
            serializer.writeStartElement(this.namespace, dom.getName());
            for (Map.Entry<String, String> attr : dom.getAttributes().entrySet()) {
                if (attr.getKey().startsWith("xml:")) {
                    serializer.writeAttribute("http://www.w3.org/XML/1998/namespace", attr.getKey().substring(4), attr.getValue());
                    continue;
                }
                serializer.writeAttribute(attr.getKey(), attr.getValue());
            }
            for (XmlNode child : dom.getChildren()) {
                this.writeDom(child, serializer);
            }
            String value = dom.getValue();
            if (value != null) {
                serializer.writeCharacters(value);
            }
            serializer.writeEndElement();
        }
    }

    private void writeTag(String tagName, String defaultValue, String value, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (value != null && !Objects.equals(defaultValue, value)) {
            serializer.writeStartElement(this.namespace, tagName);
            serializer.writeCharacters(value);
            serializer.writeEndElement();
        }
    }

    private void writeAttr(String attrName, String value, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (value != null) {
            serializer.writeAttribute(attrName, value);
        }
    }

    static class IndentingXMLStreamWriter
    extends StreamWriterDelegate {
        int depth = 0;
        boolean hasChildren = false;

        public IndentingXMLStreamWriter(XMLStreamWriter parent) {
            super(parent);
        }

        @Override
        public void writeEmptyElement(String localName) throws XMLStreamException {
            this.indent();
            super.writeEmptyElement(localName);
            this.hasChildren = true;
        }

        @Override
        public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
            this.indent();
            super.writeEmptyElement(namespaceURI, localName);
            this.hasChildren = true;
        }

        @Override
        public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.indent();
            super.writeEmptyElement(prefix, localName, namespaceURI);
            this.hasChildren = true;
        }

        @Override
        public void writeStartElement(String localName) throws XMLStreamException {
            this.indent();
            super.writeStartElement(localName);
            ++this.depth;
            this.hasChildren = false;
        }

        @Override
        public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
            this.indent();
            super.writeStartElement(namespaceURI, localName);
            ++this.depth;
            this.hasChildren = false;
        }

        @Override
        public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.indent();
            super.writeStartElement(prefix, localName, namespaceURI);
            ++this.depth;
            this.hasChildren = false;
        }

        @Override
        public void writeEndElement() throws XMLStreamException {
            --this.depth;
            if (this.hasChildren) {
                this.indent();
            }
            super.writeEndElement();
            this.hasChildren = true;
        }

        private void indent() throws XMLStreamException {
            super.writeCharacters("\n");
            for (int i = 0; i < this.depth; ++i) {
                super.writeCharacters("  ");
            }
        }
    }

    @FunctionalInterface
    private static interface ElementWriter<T> {
        public void write(T var1) throws IOException, XMLStreamException;
    }
}

