/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.xml;

import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.internal.xml.XmlNodeWriter;

public class XmlNodeImpl
implements Serializable,
XmlNode {
    private static final long serialVersionUID = 2567894443061173996L;
    protected final String prefix;
    protected final String namespaceUri;
    protected final String name;
    protected final String value;
    protected final Map<String, String> attributes;
    protected final List<XmlNode> children;
    protected final Object location;

    public XmlNodeImpl(String name) {
        this(name, null, null, null, null);
    }

    public XmlNodeImpl(String name, String value) {
        this(name, value, null, null, null);
    }

    public XmlNodeImpl(XmlNode from, String name) {
        this(name, from.getValue(), from.getAttributes(), from.getChildren(), from.getInputLocation());
    }

    public XmlNodeImpl(String name, String value, Map<String, String> attributes, List<XmlNode> children, Object location) {
        this("", "", name, value, attributes, children, location);
    }

    public XmlNodeImpl(String prefix, String namespaceUri, String name, String value, Map<String, String> attributes, List<XmlNode> children, Object location) {
        this.prefix = prefix == null ? "" : prefix;
        this.namespaceUri = namespaceUri == null ? "" : namespaceUri;
        this.name = Objects.requireNonNull(name);
        this.value = value;
        this.attributes = attributes != null ? Collections.unmodifiableMap(new HashMap<String, String>(attributes)) : Collections.emptyMap();
        this.children = children != null ? Collections.unmodifiableList(new ArrayList<XmlNode>(children)) : Collections.emptyList();
        this.location = location;
    }

    @Override
    public XmlNode merge(XmlNode source, Boolean childMergeOverride) {
        return XmlNodeImpl.merge(this, source, childMergeOverride);
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public XmlNode getChild(String name) {
        if (name != null) {
            ListIterator<XmlNode> it = this.children.listIterator(this.children.size());
            while (it.hasPrevious()) {
                XmlNode child = it.previous();
                if (!name.equals(child.getName())) continue;
                return child;
            }
        }
        return null;
    }

    @Override
    public List<XmlNode> getChildren() {
        return this.children;
    }

    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public Object getInputLocation() {
        return this.location;
    }

    public static XmlNode merge(XmlNode dominant, XmlNode recessive, Boolean childMergeOverride) {
        if (recessive == null) {
            return dominant;
        }
        if (dominant == null) {
            return recessive;
        }
        boolean mergeSelf = true;
        String selfMergeMode = dominant.getAttribute("combine.self");
        if ("override".equals(selfMergeMode)) {
            mergeSelf = false;
        }
        if (mergeSelf) {
            String value = dominant.getValue();
            Object location = dominant.getInputLocation();
            Map<String, String> attrs = dominant.getAttributes();
            List<XmlNode> children = null;
            for (Map.Entry<String, String> attr : recessive.getAttributes().entrySet()) {
                String key = attr.getKey();
                if (!XmlNodeImpl.isEmpty(attrs.get(key))) continue;
                if (attrs == dominant.getAttributes()) {
                    attrs = new HashMap<String, String>(attrs);
                }
                attrs.put(key, attr.getValue());
            }
            if (!recessive.getChildren().isEmpty()) {
                boolean mergeChildren = true;
                if (childMergeOverride != null) {
                    mergeChildren = childMergeOverride;
                } else {
                    String childMergeMode = attrs.get("combine.children");
                    if ("append".equals(childMergeMode)) {
                        mergeChildren = false;
                    }
                }
                HashMap<String, Iterator> commonChildren = new HashMap<String, Iterator>();
                Set names = recessive.getChildren().stream().map(XmlNode::getName).collect(Collectors.toSet());
                for (String name : names) {
                    List dominantChildren = dominant.getChildren().stream().filter(n -> n.getName().equals(name)).collect(Collectors.toList());
                    if (dominantChildren.isEmpty()) continue;
                    commonChildren.put(name, dominantChildren.iterator());
                }
                String keysValue = recessive.getAttribute("combine.keys");
                for (XmlNode recessiveChild : recessive.getChildren()) {
                    String idValue = recessiveChild.getAttribute("combine.id");
                    XmlNode childDom = null;
                    if (!XmlNodeImpl.isEmpty(idValue)) {
                        for (XmlNode dominantChild : dominant.getChildren()) {
                            if (!idValue.equals(dominantChild.getAttribute("combine.id"))) continue;
                            childDom = dominantChild;
                            mergeChildren = true;
                        }
                    } else if (!XmlNodeImpl.isEmpty(keysValue)) {
                        String[] keys = keysValue.split(",");
                        Map<String, Optional> recessiveKeyValues = Stream.of(keys).collect(Collectors.toMap(k -> k, k -> Optional.ofNullable(recessiveChild.getAttribute((String)k))));
                        for (XmlNode dominantChild : dominant.getChildren()) {
                            Map<String, Optional> dominantKeyValues = Stream.of(keys).collect(Collectors.toMap(k -> k, k -> Optional.ofNullable(dominantChild.getAttribute((String)k))));
                            if (!recessiveKeyValues.equals(dominantKeyValues)) continue;
                            childDom = dominantChild;
                            mergeChildren = true;
                        }
                    } else {
                        childDom = dominant.getChild(recessiveChild.getName());
                    }
                    if (mergeChildren && childDom != null) {
                        String name = recessiveChild.getName();
                        Iterator it = commonChildren.computeIfAbsent(name, n1 -> Stream.of(dominant.getChildren().stream().filter(n2 -> n2.getName().equals(n1)).collect(Collectors.toList())).filter(l -> !l.isEmpty()).map(List::iterator).findFirst().orElse(null));
                        if (it == null) {
                            if (children == null) {
                                children = new ArrayList<XmlNode>(dominant.getChildren());
                            }
                            children.add(recessiveChild);
                            continue;
                        }
                        if (!it.hasNext()) continue;
                        XmlNode dominantChild = (XmlNode)it.next();
                        String dominantChildCombinationMode = dominantChild.getAttribute("combine.self");
                        if ("remove".equals(dominantChildCombinationMode)) {
                            if (children == null) {
                                children = new ArrayList<XmlNode>(dominant.getChildren());
                            }
                            children.remove(dominantChild);
                            continue;
                        }
                        int idx = dominant.getChildren().indexOf(dominantChild);
                        XmlNode merged = XmlNodeImpl.merge(dominantChild, recessiveChild, childMergeOverride);
                        if (merged == dominantChild) continue;
                        if (children == null) {
                            children = new ArrayList<XmlNode>(dominant.getChildren());
                        }
                        children.set(idx, merged);
                        continue;
                    }
                    if (children == null) {
                        children = new ArrayList<XmlNode>(dominant.getChildren());
                    }
                    int idx = mergeChildren ? children.size() : recessive.getChildren().indexOf(recessiveChild);
                    children.add(idx, recessiveChild);
                }
            }
            if (value != null || attrs != dominant.getAttributes() || children != null) {
                if (children == null) {
                    children = dominant.getChildren();
                }
                return new XmlNodeImpl(dominant.getName(), value != null ? value : dominant.getValue(), attrs, children, location);
            }
        }
        return dominant;
    }

    public static XmlNode merge(XmlNode dominant, XmlNode recessive) {
        return XmlNodeImpl.merge(dominant, recessive, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XmlNodeImpl that = (XmlNodeImpl)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.children, that.children);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.attributes, this.children);
    }

    public String toString() {
        try {
            return this.toStringXml();
        }
        catch (XMLStreamException e) {
            return this.toStringObject();
        }
    }

    public String toStringXml() throws XMLStreamException {
        StringWriter writer = new StringWriter();
        XmlNodeWriter.write(writer, (XmlNode)this);
        return writer.toString();
    }

    public String toStringObject() {
        StringBuilder sb = new StringBuilder();
        sb.append("XmlNode[");
        boolean w = false;
        w = XmlNodeImpl.addToStringField(sb, this.prefix, o -> !o.isEmpty(), "prefix", w);
        w = XmlNodeImpl.addToStringField(sb, this.namespaceUri, o -> !o.isEmpty(), "namespaceUri", w);
        w = XmlNodeImpl.addToStringField(sb, this.name, o -> !o.isEmpty(), "name", w);
        w = XmlNodeImpl.addToStringField(sb, this.value, o -> !o.isEmpty(), "value", w);
        w = XmlNodeImpl.addToStringField(sb, this.attributes, o -> !o.isEmpty(), "attributes", w);
        w = XmlNodeImpl.addToStringField(sb, this.children, o -> !o.isEmpty(), "children", w);
        w = XmlNodeImpl.addToStringField(sb, this.location, Objects::nonNull, "location", w);
        sb.append("]");
        return sb.toString();
    }

    private static <T> boolean addToStringField(StringBuilder sb, T o, Function<T, Boolean> p, String n, boolean w) {
        if (!p.apply(o).booleanValue()) {
            if (w) {
                sb.append(", ");
            } else {
                w = true;
            }
            sb.append(n).append("='").append(o).append('\'');
        }
        return w;
    }

    private static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }
}

