/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.model.BaseObject;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.PluginConfiguration;
import org.apache.maven.model.Resource;
import org.apache.maven.model.WrapperList;

@Generated
public class BuildBase
extends PluginConfiguration
implements Serializable,
Cloneable {
    public BuildBase() {
        this(org.apache.maven.api.model.BuildBase.newInstance());
    }

    public BuildBase(org.apache.maven.api.model.BuildBase delegate) {
        this(delegate, null);
    }

    public BuildBase(org.apache.maven.api.model.BuildBase delegate, BaseObject parent) {
        super(delegate, parent);
    }

    @Override
    public BuildBase clone() {
        return new BuildBase(this.getDelegate());
    }

    @Override
    public org.apache.maven.api.model.BuildBase getDelegate() {
        return (org.apache.maven.api.model.BuildBase)super.getDelegate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof BuildBase)) {
            return false;
        }
        BuildBase that = (BuildBase)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    @Override
    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    public String getDefaultGoal() {
        return this.getDelegate().getDefaultGoal();
    }

    public void setDefaultGoal(String defaultGoal) {
        if (!Objects.equals(defaultGoal, this.getDefaultGoal())) {
            this.update(this.getDelegate().withDefaultGoal(defaultGoal));
        }
    }

    @Nonnull
    public List<Resource> getResources() {
        return new WrapperList<Resource, org.apache.maven.api.model.Resource>(() -> this.getDelegate().getResources(), l -> this.update(this.getDelegate().withResources((Collection<org.apache.maven.api.model.Resource>)l)), d -> new Resource((org.apache.maven.api.model.Resource)d, (BaseObject)this), Resource::getDelegate);
    }

    public void setResources(List<Resource> resources) {
        if (resources == null) {
            resources = Collections.emptyList();
        }
        if (!Objects.equals(resources, this.getResources())) {
            this.update(this.getDelegate().withResources(resources.stream().map(c -> c.getDelegate()).collect(Collectors.toList())));
            resources.forEach(e -> {
                e.childrenTracking = this::replace;
            });
        }
    }

    public void addResource(Resource resource) {
        this.update(this.getDelegate().withResources(Stream.concat(this.getDelegate().getResources().stream(), Stream.of(resource.getDelegate())).collect(Collectors.toList())));
        resource.childrenTracking = this::replace;
    }

    public void removeResource(Resource resource) {
        this.update(this.getDelegate().withResources(this.getDelegate().getResources().stream().filter(e -> !Objects.equals(e, resource)).collect(Collectors.toList())));
        resource.childrenTracking = null;
    }

    @Nonnull
    public List<Resource> getTestResources() {
        return new WrapperList<Resource, org.apache.maven.api.model.Resource>(() -> this.getDelegate().getTestResources(), l -> this.update(this.getDelegate().withTestResources((Collection<org.apache.maven.api.model.Resource>)l)), d -> new Resource((org.apache.maven.api.model.Resource)d, (BaseObject)this), Resource::getDelegate);
    }

    public void setTestResources(List<Resource> testResources) {
        if (testResources == null) {
            testResources = Collections.emptyList();
        }
        if (!Objects.equals(testResources, this.getTestResources())) {
            this.update(this.getDelegate().withTestResources(testResources.stream().map(c -> c.getDelegate()).collect(Collectors.toList())));
            testResources.forEach(e -> {
                e.childrenTracking = this::replace;
            });
        }
    }

    public void addTestResource(Resource testResource) {
        this.update(this.getDelegate().withTestResources(Stream.concat(this.getDelegate().getTestResources().stream(), Stream.of(testResource.getDelegate())).collect(Collectors.toList())));
        testResource.childrenTracking = this::replace;
    }

    public void removeTestResource(Resource testResource) {
        this.update(this.getDelegate().withTestResources(this.getDelegate().getTestResources().stream().filter(e -> !Objects.equals(e, testResource)).collect(Collectors.toList())));
        testResource.childrenTracking = null;
    }

    public String getDirectory() {
        return this.getDelegate().getDirectory();
    }

    public void setDirectory(String directory) {
        if (!Objects.equals(directory, this.getDirectory())) {
            this.update(this.getDelegate().withDirectory(directory));
        }
    }

    public String getFinalName() {
        return this.getDelegate().getFinalName();
    }

    public void setFinalName(String finalName) {
        if (!Objects.equals(finalName, this.getFinalName())) {
            this.update(this.getDelegate().withFinalName(finalName));
        }
    }

    @Nonnull
    public List<String> getFilters() {
        return new WrapperList<String, String>(() -> this.getDelegate().getFilters(), this::setFilters, s -> s, s -> s);
    }

    public void setFilters(List<String> filters) {
        if (!Objects.equals(filters, this.getFilters())) {
            this.update(this.getDelegate().withFilters(filters));
        }
    }

    public void addFilter(String filter) {
        this.update(this.getDelegate().withFilters(Stream.concat(this.getDelegate().getFilters().stream(), Stream.of(filter)).collect(Collectors.toList())));
    }

    public void removeFilter(String filter) {
        this.update(this.getDelegate().withFilters(this.getDelegate().getFilters().stream().filter(e -> !Objects.equals(e, filter)).collect(Collectors.toList())));
    }

    @Override
    public InputLocation getLocation(Object key) {
        org.apache.maven.api.model.InputLocation loc = this.getDelegate().getLocation(key);
        return loc != null ? new InputLocation(loc) : null;
    }

    @Override
    public void setLocation(Object key, InputLocation location) {
        this.update(org.apache.maven.api.model.BuildBase.newBuilder(this.getDelegate(), true).location(key, location.toApiLocation()).build());
    }

    @Override
    protected boolean replace(Object oldDelegate, Object newDelegate) {
        if (super.replace(oldDelegate, newDelegate)) {
            return true;
        }
        if (this.getDelegate().getResources().contains(oldDelegate)) {
            ArrayList<org.apache.maven.api.model.Resource> list = new ArrayList<org.apache.maven.api.model.Resource>(this.getDelegate().getResources());
            list.replaceAll(d -> d == oldDelegate ? (org.apache.maven.api.model.Resource)newDelegate : d);
            this.update(this.getDelegate().withResources(list));
            return true;
        }
        if (this.getDelegate().getTestResources().contains(oldDelegate)) {
            ArrayList<org.apache.maven.api.model.Resource> list = new ArrayList<org.apache.maven.api.model.Resource>(this.getDelegate().getTestResources());
            list.replaceAll(d -> d == oldDelegate ? (org.apache.maven.api.model.Resource)newDelegate : d);
            this.update(this.getDelegate().withTestResources(list));
            return true;
        }
        return false;
    }

    public static List<org.apache.maven.api.model.BuildBase> buildBaseToApiV4(List<BuildBase> list) {
        return list != null ? new WrapperList<org.apache.maven.api.model.BuildBase, BuildBase>(list, BuildBase::getDelegate, BuildBase::new) : null;
    }

    public static List<BuildBase> buildBaseToApiV3(List<org.apache.maven.api.model.BuildBase> list) {
        return list != null ? new WrapperList<BuildBase, org.apache.maven.api.model.BuildBase>(list, BuildBase::new, BuildBase::getDelegate) : null;
    }

    @Override
    public String toString() {
        return "BuildBase {" + super.toString() + "}";
    }
}

