/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.model.BaseObject;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.WrapperList;

@Generated
public class PluginContainer
extends BaseObject {
    Map<String, Plugin> pluginMap;

    public PluginContainer() {
        this(org.apache.maven.api.model.PluginContainer.newInstance());
    }

    public PluginContainer(org.apache.maven.api.model.PluginContainer delegate) {
        this(delegate, null);
    }

    public PluginContainer(org.apache.maven.api.model.PluginContainer delegate, BaseObject parent) {
        super((Object)delegate, parent);
    }

    public PluginContainer clone() {
        return new PluginContainer(this.getDelegate());
    }

    @Override
    public org.apache.maven.api.model.PluginContainer getDelegate() {
        return (org.apache.maven.api.model.PluginContainer)super.getDelegate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof PluginContainer)) {
            return false;
        }
        PluginContainer that = (PluginContainer)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    @Nonnull
    public List<Plugin> getPlugins() {
        return new WrapperList<Plugin, org.apache.maven.api.model.Plugin>(() -> this.getDelegate().getPlugins(), l -> this.update(this.getDelegate().withPlugins((Collection<org.apache.maven.api.model.Plugin>)l)), d -> new Plugin((org.apache.maven.api.model.Plugin)d, (BaseObject)this), Plugin::getDelegate);
    }

    public void setPlugins(List<Plugin> plugins) {
        if (plugins == null) {
            plugins = Collections.emptyList();
        }
        if (!Objects.equals(plugins, this.getPlugins())) {
            this.update(this.getDelegate().withPlugins(plugins.stream().map(c -> c.getDelegate()).collect(Collectors.toList())));
            plugins.forEach(e -> {
                e.childrenTracking = this::replace;
            });
        }
    }

    public void addPlugin(Plugin plugin) {
        this.update(this.getDelegate().withPlugins(Stream.concat(this.getDelegate().getPlugins().stream(), Stream.of(plugin.getDelegate())).collect(Collectors.toList())));
        plugin.childrenTracking = this::replace;
    }

    public void removePlugin(Plugin plugin) {
        this.update(this.getDelegate().withPlugins(this.getDelegate().getPlugins().stream().filter(e -> !Objects.equals(e, plugin)).collect(Collectors.toList())));
        plugin.childrenTracking = null;
    }

    @Override
    public InputLocation getLocation(Object key) {
        org.apache.maven.api.model.InputLocation loc = this.getDelegate().getLocation(key);
        return loc != null ? new InputLocation(loc) : null;
    }

    @Override
    public void setLocation(Object key, InputLocation location) {
        this.update(org.apache.maven.api.model.PluginContainer.newBuilder(this.getDelegate(), true).location(key, location.toApiLocation()).build());
    }

    @Override
    protected boolean replace(Object oldDelegate, Object newDelegate) {
        if (super.replace(oldDelegate, newDelegate)) {
            return true;
        }
        if (this.getDelegate().getPlugins().contains(oldDelegate)) {
            ArrayList<org.apache.maven.api.model.Plugin> list = new ArrayList<org.apache.maven.api.model.Plugin>(this.getDelegate().getPlugins());
            list.replaceAll(d -> d == oldDelegate ? (org.apache.maven.api.model.Plugin)newDelegate : d);
            this.update(this.getDelegate().withPlugins(list));
            return true;
        }
        return false;
    }

    public static List<org.apache.maven.api.model.PluginContainer> pluginContainerToApiV4(List<PluginContainer> list) {
        return list != null ? new WrapperList<org.apache.maven.api.model.PluginContainer, PluginContainer>(list, PluginContainer::getDelegate, PluginContainer::new) : null;
    }

    public static List<PluginContainer> pluginContainerToApiV3(List<org.apache.maven.api.model.PluginContainer> list) {
        return list != null ? new WrapperList<PluginContainer, org.apache.maven.api.model.PluginContainer>(list, PluginContainer::new, PluginContainer::getDelegate) : null;
    }

    public synchronized void flushPluginMap() {
        this.pluginMap = null;
    }

    public synchronized Map<String, Plugin> getPluginsAsMap() {
        if (this.pluginMap == null) {
            this.pluginMap = new LinkedHashMap<String, Plugin>();
            if (this.getPlugins() != null) {
                for (Plugin plugin : this.getPlugins()) {
                    this.pluginMap.put(plugin.getKey(), plugin);
                }
            }
        }
        return this.pluginMap;
    }

    public String toString() {
        return "PluginContainer {}";
    }
}

