/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.composition;

import java.util.LinkedHashMap;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.model.Dependency;
import org.apache.maven.api.model.DependencyManagement;
import org.apache.maven.api.model.Model;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.composition.DependencyManagementImporter;

@Named
@Singleton
public class DefaultDependencyManagementImporter
implements DependencyManagementImporter {
    @Override
    public Model importManagement(Model target, List<? extends DependencyManagement> sources, ModelBuildingRequest request, ModelProblemCollector problems) {
        if (sources != null && !sources.isEmpty()) {
            LinkedHashMap<String, Dependency> dependencies = new LinkedHashMap<String, Dependency>();
            DependencyManagement depMgmt = target.getDependencyManagement();
            if (depMgmt != null) {
                for (Dependency dependency : depMgmt.getDependencies()) {
                    dependencies.put(dependency.getManagementKey(), dependency);
                }
            } else {
                depMgmt = DependencyManagement.newInstance();
            }
            for (DependencyManagement dependencyManagement : sources) {
                for (Dependency dependency : dependencyManagement.getDependencies()) {
                    String key = dependency.getManagementKey();
                    dependencies.putIfAbsent(key, dependency);
                }
            }
            return target.withDependencyManagement(depMgmt.withDependencies(dependencies.values()));
        }
        return target;
    }
}

