/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.management;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.model.Dependency;
import org.apache.maven.api.model.DependencyManagement;
import org.apache.maven.api.model.Exclusion;
import org.apache.maven.api.model.Model;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.management.DependencyManagementInjector;
import org.apache.maven.model.merge.MavenModelMerger;

@Named
@Singleton
public class DefaultDependencyManagementInjector
implements DependencyManagementInjector {
    private ManagementModelMerger merger = new ManagementModelMerger();

    @Override
    public void injectManagement(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        model.update(this.merger.mergeManagedDependencies(model.getDelegate()));
    }

    protected static class ManagementModelMerger
    extends MavenModelMerger {
        protected ManagementModelMerger() {
        }

        public org.apache.maven.api.model.Model mergeManagedDependencies(org.apache.maven.api.model.Model model) {
            DependencyManagement dependencyManagement = model.getDependencyManagement();
            if (dependencyManagement != null) {
                HashMap dependencies = new HashMap();
                Map<Object, Object> context = Collections.emptyMap();
                for (Dependency dependency : model.getDependencies()) {
                    Object key = this.getDependencyKey().apply(dependency);
                    dependencies.put(key, dependency);
                }
                boolean modified = false;
                for (Dependency managedDependency : dependencyManagement.getDependencies()) {
                    Dependency merged;
                    Object key = this.getDependencyKey().apply(managedDependency);
                    Dependency dependency = (Dependency)dependencies.get(key);
                    if (dependency == null || (merged = this.mergeDependency(dependency, managedDependency, false, context)) == dependency) continue;
                    dependencies.put(key, merged);
                    modified = true;
                }
                if (modified) {
                    ArrayList<Dependency> arrayList = new ArrayList<Dependency>(dependencies.size());
                    for (Dependency dep : model.getDependencies()) {
                        Object key = this.getDependencyKey().apply(dep);
                        Dependency dependency = (Dependency)dependencies.get(key);
                        arrayList.add(dependency);
                    }
                    return ((Model.Builder)org.apache.maven.api.model.Model.newBuilder(model).dependencies(arrayList)).build();
                }
            }
            return model;
        }

        @Override
        protected void mergeDependency_Optional(Dependency.Builder builder, Dependency target, Dependency source, boolean sourceDominant, Map<Object, Object> context) {
        }

        @Override
        protected void mergeDependency_Exclusions(Dependency.Builder builder, Dependency target, Dependency source, boolean sourceDominant, Map<Object, Object> context) {
            List<Exclusion> tgt = target.getExclusions();
            if (tgt.isEmpty()) {
                List<Exclusion> src = source.getExclusions();
                builder.exclusions(src);
            }
        }
    }
}

