/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.plugin;

import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.model.Model;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.plugin.ReportConfigurationExpander;

@Named
@Singleton
public class DefaultReportConfigurationExpander
implements ReportConfigurationExpander {
    @Override
    public void expandPluginConfiguration(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        Reporting reporting = model.getReporting();
        if (reporting != null) {
            for (ReportPlugin reportPlugin : reporting.getPlugins()) {
                XmlNode parentDom = reportPlugin.getDelegate().getConfiguration();
                if (parentDom == null) continue;
                for (ReportSet execution : reportPlugin.getReportSets()) {
                    XmlNode childDom = execution.getDelegate().getConfiguration();
                    childDom = XmlNode.merge(childDom, parentDom);
                    execution.update(execution.getDelegate().withConfiguration(childDom));
                }
            }
        }
    }
}

