/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal;

import java.util.Objects;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.VersionConstraint;
import org.apache.maven.api.VersionRange;
import org.apache.maven.api.services.VersionParserException;
import org.apache.maven.model.version.ModelVersionParser;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionRange;
import org.eclipse.aether.version.VersionScheme;

@Named
@Singleton
public class DefaultModelVersionParser
implements ModelVersionParser {
    private static final String SNAPSHOT = "SNAPSHOT";
    private static final Pattern SNAPSHOT_TIMESTAMP = Pattern.compile("^(.*-)?([0-9]{8}\\.[0-9]{6}-[0-9]+)$");
    private final VersionScheme versionScheme;

    @Inject
    public DefaultModelVersionParser(VersionScheme versionScheme) {
        this.versionScheme = Objects.requireNonNull(versionScheme, "versionScheme");
    }

    @Override
    public org.apache.maven.api.Version parseVersion(String version) {
        Objects.requireNonNull(version, "version");
        return new DefaultVersion(this.versionScheme, version);
    }

    @Override
    public VersionRange parseVersionRange(String range) {
        Objects.requireNonNull(range, "range");
        return new DefaultVersionRange(this.versionScheme, range);
    }

    @Override
    public boolean isSnapshot(String version) {
        return DefaultModelVersionParser.checkSnapshot(version);
    }

    public static boolean checkSnapshot(String version) {
        return version.endsWith(SNAPSHOT) || SNAPSHOT_TIMESTAMP.matcher(version).matches();
    }

    @Override
    public VersionConstraint parseVersionConstraint(String constraint) {
        Objects.requireNonNull(constraint, "constraint");
        return new DefaultVersionConstraint(this.versionScheme, constraint);
    }

    static class DefaultVersion
    implements org.apache.maven.api.Version {
        private final VersionScheme versionScheme;
        private final Version delegate;

        DefaultVersion(VersionScheme versionScheme, Version delegate) {
            this.versionScheme = versionScheme;
            this.delegate = delegate;
        }

        DefaultVersion(VersionScheme versionScheme, String delegateValue) {
            this.versionScheme = versionScheme;
            try {
                this.delegate = versionScheme.parseVersion(delegateValue);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new VersionParserException("Unable to parse version: " + delegateValue, e);
            }
        }

        @Override
        public int compareTo(org.apache.maven.api.Version o) {
            if (o instanceof DefaultVersion) {
                return this.delegate.compareTo(((DefaultVersion)o).delegate);
            }
            return this.compareTo(new DefaultVersion(this.versionScheme, o.asString()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultVersion that = (DefaultVersion)o;
            return this.delegate.equals(that.delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        @Override
        public String asString() {
            return this.delegate.toString();
        }

        public String toString() {
            return this.asString();
        }
    }

    static class DefaultVersionRange
    implements VersionRange {
        private final VersionScheme versionScheme;
        private final org.eclipse.aether.version.VersionRange delegate;

        DefaultVersionRange(VersionScheme versionScheme, org.eclipse.aether.version.VersionRange delegate) {
            this.versionScheme = versionScheme;
            this.delegate = delegate;
        }

        DefaultVersionRange(VersionScheme versionScheme, String delegateValue) {
            this.versionScheme = versionScheme;
            try {
                this.delegate = versionScheme.parseVersionRange(delegateValue);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new VersionParserException("Unable to parse version range: " + delegateValue, e);
            }
        }

        @Override
        public boolean contains(org.apache.maven.api.Version version) {
            if (version instanceof DefaultVersion) {
                return this.delegate.containsVersion(((DefaultVersion)version).delegate);
            }
            return this.contains(new DefaultVersion(this.versionScheme, version.asString()));
        }

        @Override
        public VersionRange.Boundary getUpperBoundary() {
            final VersionRange.Bound bound = this.delegate.getUpperBound();
            if (bound == null) {
                return null;
            }
            return new VersionRange.Boundary(){

                @Override
                public org.apache.maven.api.Version getVersion() {
                    return new DefaultVersion(versionScheme, bound.getVersion());
                }

                @Override
                public boolean isInclusive() {
                    return bound.isInclusive();
                }
            };
        }

        @Override
        public VersionRange.Boundary getLowerBoundary() {
            final VersionRange.Bound bound = this.delegate.getLowerBound();
            if (bound == null) {
                return null;
            }
            return new VersionRange.Boundary(){

                @Override
                public org.apache.maven.api.Version getVersion() {
                    return new DefaultVersion(versionScheme, bound.getVersion());
                }

                @Override
                public boolean isInclusive() {
                    return bound.isInclusive();
                }
            };
        }

        @Override
        public String asString() {
            return this.delegate.toString();
        }

        public String toString() {
            return this.asString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultVersionRange that = (DefaultVersionRange)o;
            return this.delegate.equals(that.delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }
    }

    static class DefaultVersionConstraint
    implements VersionConstraint {
        private final VersionScheme versionScheme;
        private final org.eclipse.aether.version.VersionConstraint delegate;

        DefaultVersionConstraint(VersionScheme versionScheme, String delegateValue) {
            this.versionScheme = versionScheme;
            try {
                this.delegate = versionScheme.parseVersionConstraint(delegateValue);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new VersionParserException("Unable to parse version constraint: " + delegateValue, e);
            }
        }

        @Override
        public boolean contains(org.apache.maven.api.Version version) {
            if (version instanceof DefaultVersion) {
                return this.delegate.containsVersion(((DefaultVersion)version).delegate);
            }
            return this.contains(new DefaultVersion(this.versionScheme, version.asString()));
        }

        @Override
        public String asString() {
            return this.delegate.toString();
        }

        @Override
        public VersionRange getVersionRange() {
            if (this.delegate.getRange() == null) {
                return null;
            }
            return new DefaultVersionRange(this.versionScheme, this.delegate.getRange());
        }

        @Override
        public org.apache.maven.api.Version getRecommendedVersion() {
            if (this.delegate.getVersion() == null) {
                return null;
            }
            return new DefaultVersion(this.versionScheme, this.delegate.getVersion());
        }

        public String toString() {
            return this.asString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultVersionConstraint that = (DefaultVersionConstraint)o;
            return this.delegate.equals(that.delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }
    }
}

