/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether;

import java.util.Map;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;

public interface SystemScopeHandler {
    public static final SystemScopeHandler LEGACY = new SystemScopeHandler(){

        @Override
        public boolean isSystemScope(String scope) {
            return "system".equals(scope);
        }

        @Override
        public String getSystemPath(Artifact artifact) {
            return artifact.getProperty("localPath", null);
        }

        @Override
        public void setSystemPath(Map<String, String> properties, String systemPath) {
            if (systemPath == null) {
                properties.remove("localPath");
            } else {
                properties.put("localPath", systemPath);
            }
        }
    };

    public boolean isSystemScope(String var1);

    default public boolean isSystemScope(Dependency dependency) {
        return dependency != null && this.isSystemScope(dependency.getScope());
    }

    default public boolean isSystemScope(DependencyNode dependencyNode) {
        return dependencyNode != null && dependencyNode.getDependency() != null && this.isSystemScope(dependencyNode.getDependency());
    }

    public String getSystemPath(Artifact var1);

    public void setSystemPath(Map<String, String> var1, String var2);
}

