/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.spi.io.ChecksumProcessor;
import org.eclipse.aether.spi.io.PathProcessor;

@Singleton
@Named
public class DefaultChecksumProcessor
implements ChecksumProcessor {
    private final PathProcessor pathProcessor;

    @Inject
    public DefaultChecksumProcessor(PathProcessor pathProcessor) {
        this.pathProcessor = Objects.requireNonNull(pathProcessor);
    }

    @Override
    public String readChecksum(Path checksumPath) throws IOException {
        String checksum;
        block10: {
            checksum = "";
            try (BufferedReader br = Files.newBufferedReader(checksumPath, StandardCharsets.UTF_8);){
                String line;
                do {
                    if ((line = br.readLine()) != null) continue;
                    break block10;
                } while ((line = line.trim()).isEmpty());
                checksum = line;
            }
        }
        if (checksum.matches(".+= [0-9A-Fa-f]+")) {
            int lastSpacePos = checksum.lastIndexOf(32);
            checksum = checksum.substring(lastSpacePos + 1);
        } else {
            int spacePos = checksum.indexOf(32);
            if (spacePos != -1) {
                checksum = checksum.substring(0, spacePos);
            }
        }
        return checksum;
    }

    @Override
    public void writeChecksum(Path target, String checksum) throws IOException {
        this.pathProcessor.write(target, checksum);
    }
}

