/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.internal.impl.PrioritizedComponent;
import org.eclipse.aether.internal.impl.PrioritizedComponents;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.layout.RepositoryLayout;
import org.eclipse.aether.spi.connector.layout.RepositoryLayoutFactory;
import org.eclipse.aether.spi.connector.layout.RepositoryLayoutProvider;
import org.eclipse.aether.transfer.NoRepositoryLayoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public final class DefaultRepositoryLayoutProvider
implements RepositoryLayoutProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRepositoryLayoutProvider.class);
    private final Map<String, RepositoryLayoutFactory> layoutFactories;

    @Inject
    public DefaultRepositoryLayoutProvider(Map<String, RepositoryLayoutFactory> layoutFactories) {
        this.layoutFactories = Collections.unmodifiableMap(layoutFactories);
    }

    @Override
    public RepositoryLayout newRepositoryLayout(RepositorySystemSession session, RemoteRepository repository) throws NoRepositoryLayoutException {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(repository, "remote repository cannot be null");
        PrioritizedComponents<RepositoryLayoutFactory> factories = PrioritizedComponents.reuseOrCreate(session, this.layoutFactories, RepositoryLayoutFactory::getPriority);
        ArrayList<NoRepositoryLayoutException> errors = new ArrayList<NoRepositoryLayoutException>();
        for (PrioritizedComponent<RepositoryLayoutFactory> prioritizedComponent : factories.getEnabled()) {
            try {
                return prioritizedComponent.getComponent().newInstance(session, repository);
            }
            catch (NoRepositoryLayoutException e) {
                errors.add(e);
            }
        }
        if (LOGGER.isDebugEnabled() && errors.size() > 1) {
            for (Exception exception : errors) {
                LOGGER.debug("Could not obtain layout factory for {}", (Object)repository, (Object)exception);
            }
        }
        StringBuilder buffer = new StringBuilder(256);
        if (factories.isEmpty()) {
            buffer.append("No layout factories registered");
        } else {
            buffer.append("Cannot access ").append(repository.getUrl());
            buffer.append(" with type ").append(repository.getContentType());
            buffer.append(" using the available layout factories: ");
            factories.list(buffer);
        }
        throw new NoRepositoryLayoutException(repository, buffer.toString(), errors.size() == 1 ? (Throwable)errors.get(0) : null);
    }
}

