/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.MultiRuntimeException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.RepositorySystemLifecycle;

@Singleton
@Named
public class DefaultRepositorySystemLifecycle
implements RepositorySystemLifecycle {
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final CopyOnWriteArrayList<Runnable> onSystemEndedHandlers = new CopyOnWriteArrayList();
    private final ConcurrentHashMap<String, CopyOnWriteArrayList<Runnable>> onSessionEndedHandlers = new ConcurrentHashMap();

    @Inject
    public DefaultRepositorySystemLifecycle() {
    }

    @Override
    public void systemEnded() {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        if (this.shutdown.compareAndSet(false, true)) {
            for (Map.Entry<String, CopyOnWriteArrayList<Runnable>> sessionEndedHandlers : this.onSessionEndedHandlers.entrySet()) {
                IllegalStateException sessionNotClosed = new IllegalStateException("Session " + sessionEndedHandlers.getKey() + " not closed");
                exceptions.add(sessionNotClosed);
                for (Runnable onCloseHandler : sessionEndedHandlers.getValue()) {
                    try {
                        onCloseHandler.run();
                    }
                    catch (Exception e) {
                        sessionNotClosed.addSuppressed(e);
                    }
                }
            }
            for (Runnable onCloseHandler : this.onSystemEndedHandlers) {
                try {
                    onCloseHandler.run();
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
            MultiRuntimeException.mayThrow("system on-close handler failures", exceptions);
        }
    }

    @Override
    public void addOnSystemEndedHandler(Runnable handler) {
        Objects.requireNonNull(handler, "handler cannot be null");
        this.requireNotShutdown();
        this.onSystemEndedHandlers.add(0, handler);
    }

    @Override
    public void sessionStarted(RepositorySystemSession.CloseableSession session) {
        Objects.requireNonNull(session, "session cannot be null");
        this.requireNotShutdown();
        String sessionId = session.sessionId();
        this.onSessionEndedHandlers.compute(sessionId, (k, v) -> {
            if (v != null) {
                throw new IllegalStateException("session instance already registered");
            }
            return new CopyOnWriteArrayList();
        });
    }

    @Override
    public void sessionEnded(RepositorySystemSession.CloseableSession session) {
        Objects.requireNonNull(session, "session cannot be null");
        this.requireNotShutdown();
        String sessionId = session.sessionId();
        ArrayList handlers = new ArrayList();
        this.onSessionEndedHandlers.compute(sessionId, (k, v) -> {
            if (v == null) {
                throw new IllegalStateException("session instance not registered");
            }
            handlers.addAll(v);
            return null;
        });
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Runnable handler : handlers) {
            try {
                handler.run();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        MultiRuntimeException.mayThrow("sessionEnded handler issue(s)", exceptions);
    }

    @Override
    public void addOnSessionEndedHandle(RepositorySystemSession.CloseableSession session, Runnable handler) {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(handler, "handler cannot be null");
        this.requireNotShutdown();
        String sessionId = session.sessionId();
        this.onSessionEndedHandlers.compute(sessionId, (k, v) -> {
            if (v == null) {
                throw new IllegalStateException("session instance not registered");
            }
            v.add(handler);
            return v;
        });
    }

    private void requireNotShutdown() {
        if (this.shutdown.get()) {
            throw new IllegalStateException("repository system is already shut down");
        }
    }
}

