/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.internal.impl.PrioritizedComponent;
import org.eclipse.aether.internal.impl.PrioritizedComponents;
import org.eclipse.aether.internal.impl.Utils;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.transport.Transporter;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.spi.connector.transport.TransporterProvider;
import org.eclipse.aether.transfer.NoTransporterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public final class DefaultTransporterProvider
implements TransporterProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTransporterProvider.class);
    private final Map<String, TransporterFactory> transporterFactories;

    @Inject
    public DefaultTransporterProvider(Map<String, TransporterFactory> transporterFactories) {
        this.transporterFactories = Collections.unmodifiableMap(transporterFactories);
    }

    @Override
    public Transporter newTransporter(RepositorySystemSession session, RemoteRepository repository) throws NoTransporterException {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        PrioritizedComponents<TransporterFactory> factories = PrioritizedComponents.reuseOrCreate(session, this.transporterFactories, TransporterFactory::getPriority);
        ArrayList<NoTransporterException> errors = new ArrayList<NoTransporterException>();
        for (PrioritizedComponent<TransporterFactory> prioritizedComponent : factories.getEnabled()) {
            try {
                Transporter transporter = prioritizedComponent.getComponent().newInstance(session, repository);
                if (LOGGER.isDebugEnabled()) {
                    StringBuilder buffer = new StringBuilder(256);
                    buffer.append("Using transporter ").append(transporter.getClass().getSimpleName());
                    Utils.appendClassLoader(buffer, transporter);
                    buffer.append(" with priority ").append(prioritizedComponent.getPriority());
                    buffer.append(" for ").append(repository.getUrl());
                    LOGGER.debug(buffer.toString());
                }
                return transporter;
            }
            catch (NoTransporterException e) {
                errors.add(e);
            }
        }
        if (LOGGER.isDebugEnabled() && errors.size() > 1) {
            for (Exception exception : errors) {
                LOGGER.debug("Could not obtain transporter factory for {}", (Object)repository, (Object)exception);
            }
        }
        StringBuilder buffer = new StringBuilder(256);
        if (factories.isEmpty()) {
            buffer.append("No transporter factories registered");
        } else {
            buffer.append("Cannot access ").append(repository.getUrl());
            buffer.append(" using the registered transporter factories: ");
            factories.list(buffer);
        }
        throw new NoTransporterException(repository, buffer.toString(), errors.size() == 1 ? (Throwable)errors.get(0) : null);
    }
}

