/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.checksum;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactorySelector;

@Singleton
@Named
public class DefaultChecksumAlgorithmFactorySelector
implements ChecksumAlgorithmFactorySelector {
    private final Map<String, ChecksumAlgorithmFactory> factories;

    @Inject
    public DefaultChecksumAlgorithmFactorySelector(Map<String, ChecksumAlgorithmFactory> factories) {
        this.factories = Objects.requireNonNull(factories);
    }

    @Override
    public ChecksumAlgorithmFactory select(String algorithmName) {
        Objects.requireNonNull(algorithmName, "algorithmMame must not be null");
        ChecksumAlgorithmFactory factory = this.factories.get(algorithmName);
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Unsupported checksum algorithm %s, supported ones are %s", algorithmName, this.getChecksumAlgorithmFactories().stream().map(ChecksumAlgorithmFactory::getName).collect(Collectors.toList())));
        }
        return factory;
    }

    @Override
    public List<ChecksumAlgorithmFactory> selectList(Collection<String> algorithmNames) {
        return algorithmNames.stream().map(this::select).collect(Collectors.toList());
    }

    @Override
    public Collection<ChecksumAlgorithmFactory> getChecksumAlgorithmFactories() {
        return Collections.unmodifiableCollection(this.factories.values());
    }

    @Override
    public boolean isChecksumExtension(String extension) {
        Objects.requireNonNull(extension);
        if (extension.contains(".")) {
            return this.factories.values().stream().anyMatch(a -> extension.endsWith("." + a.getFileExtension()));
        }
        return this.factories.values().stream().anyMatch(a -> extension.equals(a.getFileExtension()));
    }
}

