/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.checksum;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.spi.checksums.TrustedChecksumsSource;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import org.eclipse.aether.util.DirectoryUtils;

abstract class FileTrustedChecksumsSourceSupport
implements TrustedChecksumsSource {
    protected static final String CONFIG_PROPS_PREFIX = "aether.trustedChecksumsSource.";

    FileTrustedChecksumsSourceSupport() {
    }

    @Override
    public Map<String, String> getTrustedArtifactChecksums(RepositorySystemSession session, Artifact artifact, ArtifactRepository artifactRepository, List<ChecksumAlgorithmFactory> checksumAlgorithmFactories) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(artifact, "artifact is null");
        Objects.requireNonNull(artifactRepository, "artifactRepository is null");
        Objects.requireNonNull(checksumAlgorithmFactories, "checksumAlgorithmFactories is null");
        if (this.isEnabled(session)) {
            return Objects.requireNonNull(this.doGetTrustedArtifactChecksums(session, artifact, artifactRepository, checksumAlgorithmFactories));
        }
        return null;
    }

    @Override
    public TrustedChecksumsSource.Writer getTrustedArtifactChecksumsWriter(RepositorySystemSession session) {
        Objects.requireNonNull(session, "session is null");
        if (this.isEnabled(session)) {
            return this.doGetTrustedArtifactChecksumsWriter(session);
        }
        return null;
    }

    protected abstract Map<String, String> doGetTrustedArtifactChecksums(RepositorySystemSession var1, Artifact var2, ArtifactRepository var3, List<ChecksumAlgorithmFactory> var4);

    protected TrustedChecksumsSource.Writer doGetTrustedArtifactChecksumsWriter(RepositorySystemSession session) {
        return null;
    }

    protected abstract boolean isEnabled(RepositorySystemSession var1);

    protected Path getBasedir(RepositorySystemSession session, String defaultValue, String configPropKey, boolean mayCreate) {
        try {
            return DirectoryUtils.resolveDirectory(session, defaultValue, configPropKey, mayCreate);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

