/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.session;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.aether.DefaultSessionData;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.SessionData;
import org.eclipse.aether.SystemScopeHandler;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.collection.DependencyManager;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.collection.DependencyTraverser;
import org.eclipse.aether.collection.VersionFilter;
import org.eclipse.aether.impl.RepositorySystemLifecycle;
import org.eclipse.aether.internal.impl.session.DefaultCloseableSession;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.resolution.ResolutionErrorPolicy;
import org.eclipse.aether.transfer.TransferListener;

public final class DefaultSessionBuilder
implements RepositorySystemSession.SessionBuilder {
    private static final MirrorSelector NULL_MIRROR_SELECTOR = r -> null;
    private static final ProxySelector NULL_PROXY_SELECTOR = RemoteRepository::getProxy;
    private static final AuthenticationSelector NULL_AUTHENTICATION_SELECTOR = RemoteRepository::getAuthentication;
    private static final ArtifactTypeRegistry NULL_ARTIFACT_TYPE_REGISTRY = t -> null;
    private static final Supplier<SessionData> DEFAULT_SESSION_DATA_SUPPLIER = DefaultSessionData::new;
    private static final Supplier<RepositoryCache> DEFAULT_REPOSITORY_CACHE_SUPPLIER = () -> null;
    private final RepositorySystem repositorySystem;
    private final RepositorySystemLifecycle repositorySystemLifecycle;
    private final Supplier<String> sessionIdSupplier;
    private boolean offline;
    private boolean ignoreArtifactDescriptorRepositories;
    private ResolutionErrorPolicy resolutionErrorPolicy;
    private ArtifactDescriptorPolicy artifactDescriptorPolicy;
    private String checksumPolicy;
    private String artifactUpdatePolicy;
    private String metadataUpdatePolicy;
    private LocalRepositoryManager localRepositoryManager;
    private Collection<LocalRepository> localRepositories;
    private WorkspaceReader workspaceReader;
    private final ArrayList<RepositoryListener> repositoryListener = new ArrayList();
    private final ArrayList<TransferListener> transferListener = new ArrayList();
    private Map<String, String> systemProperties = new HashMap<String, String>();
    private Map<String, String> userProperties = new HashMap<String, String>();
    private Map<String, Object> configProperties = new HashMap<String, Object>();
    private MirrorSelector mirrorSelector = NULL_MIRROR_SELECTOR;
    private ProxySelector proxySelector = NULL_PROXY_SELECTOR;
    private AuthenticationSelector authenticationSelector = NULL_AUTHENTICATION_SELECTOR;
    private ArtifactTypeRegistry artifactTypeRegistry = NULL_ARTIFACT_TYPE_REGISTRY;
    private DependencyTraverser dependencyTraverser;
    private DependencyManager dependencyManager;
    private DependencySelector dependencySelector;
    private VersionFilter versionFilter;
    private DependencyGraphTransformer dependencyGraphTransformer;
    private Supplier<SessionData> sessionDataSupplier = DEFAULT_SESSION_DATA_SUPPLIER;
    private Supplier<RepositoryCache> repositoryCacheSupplier = DEFAULT_REPOSITORY_CACHE_SUPPLIER;
    private SystemScopeHandler systemScopeHandler = SystemScopeHandler.LEGACY;
    private final ArrayList<Runnable> onSessionCloseHandlers = new ArrayList();

    public DefaultSessionBuilder(RepositorySystem repositorySystem, RepositorySystemLifecycle repositorySystemLifecycle, Supplier<String> sessionIdSupplier) {
        this.repositorySystem = Objects.requireNonNull(repositorySystem);
        this.repositorySystemLifecycle = Objects.requireNonNull(repositorySystemLifecycle);
        this.sessionIdSupplier = Objects.requireNonNull(sessionIdSupplier);
    }

    @Override
    public DefaultSessionBuilder setOffline(boolean offline) {
        this.offline = offline;
        return this;
    }

    @Override
    public DefaultSessionBuilder setIgnoreArtifactDescriptorRepositories(boolean ignoreArtifactDescriptorRepositories) {
        this.ignoreArtifactDescriptorRepositories = ignoreArtifactDescriptorRepositories;
        return this;
    }

    @Override
    public DefaultSessionBuilder setResolutionErrorPolicy(ResolutionErrorPolicy resolutionErrorPolicy) {
        this.resolutionErrorPolicy = resolutionErrorPolicy;
        return this;
    }

    @Override
    public DefaultSessionBuilder setArtifactDescriptorPolicy(ArtifactDescriptorPolicy artifactDescriptorPolicy) {
        this.artifactDescriptorPolicy = artifactDescriptorPolicy;
        return this;
    }

    @Override
    public DefaultSessionBuilder setChecksumPolicy(String checksumPolicy) {
        this.checksumPolicy = checksumPolicy;
        return this;
    }

    @Override
    public DefaultSessionBuilder setUpdatePolicy(String updatePolicy) {
        this.setArtifactUpdatePolicy(updatePolicy);
        this.setMetadataUpdatePolicy(updatePolicy);
        return this;
    }

    @Override
    public DefaultSessionBuilder setArtifactUpdatePolicy(String artifactUpdatePolicy) {
        this.artifactUpdatePolicy = artifactUpdatePolicy;
        return this;
    }

    @Override
    public DefaultSessionBuilder setMetadataUpdatePolicy(String metadataUpdatePolicy) {
        this.metadataUpdatePolicy = metadataUpdatePolicy;
        return this;
    }

    @Override
    public DefaultSessionBuilder setLocalRepositoryManager(LocalRepositoryManager localRepositoryManager) {
        this.localRepositoryManager = localRepositoryManager;
        return this;
    }

    @Override
    public DefaultSessionBuilder setWorkspaceReader(WorkspaceReader workspaceReader) {
        this.workspaceReader = workspaceReader;
        return this;
    }

    @Override
    public DefaultSessionBuilder setRepositoryListener(RepositoryListener repositoryListener) {
        this.repositoryListener.clear();
        if (repositoryListener != null) {
            this.repositoryListener.add(repositoryListener);
        }
        return this;
    }

    @Override
    public DefaultSessionBuilder setTransferListener(TransferListener transferListener) {
        this.transferListener.clear();
        if (transferListener != null) {
            this.transferListener.add(transferListener);
        }
        return this;
    }

    @Override
    public DefaultSessionBuilder setSystemProperties(Map<?, ?> systemProperties) {
        this.systemProperties = DefaultSessionBuilder.copySafe(systemProperties, String.class);
        return this;
    }

    @Override
    public DefaultSessionBuilder setSystemProperty(String key, String value) {
        if (value != null) {
            this.systemProperties.put(key, value);
        } else {
            this.systemProperties.remove(key);
        }
        return this;
    }

    @Override
    public DefaultSessionBuilder setUserProperties(Map<?, ?> userProperties) {
        this.userProperties = DefaultSessionBuilder.copySafe(userProperties, String.class);
        return this;
    }

    @Override
    public DefaultSessionBuilder setUserProperty(String key, String value) {
        if (value != null) {
            this.userProperties.put(key, value);
        } else {
            this.userProperties.remove(key);
        }
        return this;
    }

    @Override
    public DefaultSessionBuilder setConfigProperties(Map<?, ?> configProperties) {
        this.configProperties = DefaultSessionBuilder.copySafe(configProperties, Object.class);
        return this;
    }

    @Override
    public DefaultSessionBuilder setConfigProperty(String key, Object value) {
        if (value != null) {
            this.configProperties.put(key, value);
        } else {
            this.configProperties.remove(key);
        }
        return this;
    }

    @Override
    public DefaultSessionBuilder setMirrorSelector(MirrorSelector mirrorSelector) {
        this.mirrorSelector = mirrorSelector;
        if (this.mirrorSelector == null) {
            this.mirrorSelector = NULL_MIRROR_SELECTOR;
        }
        return this;
    }

    @Override
    public DefaultSessionBuilder setProxySelector(ProxySelector proxySelector) {
        this.proxySelector = proxySelector;
        if (this.proxySelector == null) {
            this.proxySelector = NULL_PROXY_SELECTOR;
        }
        return this;
    }

    @Override
    public DefaultSessionBuilder setAuthenticationSelector(AuthenticationSelector authenticationSelector) {
        this.authenticationSelector = authenticationSelector;
        if (this.authenticationSelector == null) {
            this.authenticationSelector = NULL_AUTHENTICATION_SELECTOR;
        }
        return this;
    }

    @Override
    public DefaultSessionBuilder setArtifactTypeRegistry(ArtifactTypeRegistry artifactTypeRegistry) {
        this.artifactTypeRegistry = artifactTypeRegistry;
        if (this.artifactTypeRegistry == null) {
            this.artifactTypeRegistry = NULL_ARTIFACT_TYPE_REGISTRY;
        }
        return this;
    }

    @Override
    public DefaultSessionBuilder setDependencyTraverser(DependencyTraverser dependencyTraverser) {
        this.dependencyTraverser = dependencyTraverser;
        return this;
    }

    @Override
    public DefaultSessionBuilder setDependencyManager(DependencyManager dependencyManager) {
        this.dependencyManager = dependencyManager;
        return this;
    }

    @Override
    public DefaultSessionBuilder setDependencySelector(DependencySelector dependencySelector) {
        this.dependencySelector = dependencySelector;
        return this;
    }

    @Override
    public DefaultSessionBuilder setVersionFilter(VersionFilter versionFilter) {
        this.versionFilter = versionFilter;
        return this;
    }

    @Override
    public DefaultSessionBuilder setDependencyGraphTransformer(DependencyGraphTransformer dependencyGraphTransformer) {
        this.dependencyGraphTransformer = dependencyGraphTransformer;
        return this;
    }

    @Override
    public DefaultSessionBuilder setData(SessionData data) {
        return this.setSessionDataSupplier(() -> data);
    }

    @Override
    public DefaultSessionBuilder setSessionDataSupplier(Supplier<SessionData> dataSupplier) {
        Objects.requireNonNull(dataSupplier, "null dataSupplier");
        this.sessionDataSupplier = dataSupplier;
        return this;
    }

    @Override
    public DefaultSessionBuilder setCache(RepositoryCache cache) {
        return this.setRepositoryCacheSupplier(() -> cache);
    }

    @Override
    public DefaultSessionBuilder setSystemScopeHandler(SystemScopeHandler systemScopeHandler) {
        Objects.requireNonNull(systemScopeHandler, "null systemScopeHandler");
        this.systemScopeHandler = systemScopeHandler;
        return this;
    }

    @Override
    public RepositorySystemSession.SessionBuilder addOnSessionEndedHandler(Runnable handler) {
        Objects.requireNonNull(handler, "null handler");
        this.onSessionCloseHandlers.add(handler);
        return this;
    }

    @Override
    public DefaultSessionBuilder setRepositoryCacheSupplier(Supplier<RepositoryCache> cacheSupplier) {
        Objects.requireNonNull(cacheSupplier, "null cacheSupplier");
        this.repositoryCacheSupplier = cacheSupplier;
        return this;
    }

    @Override
    public RepositorySystemSession.SessionBuilder withLocalRepositoryBaseDirectories(Path ... baseDirectories) {
        return this.withLocalRepositoryBaseDirectories(Arrays.asList(baseDirectories));
    }

    @Override
    public RepositorySystemSession.SessionBuilder withLocalRepositoryBaseDirectories(Collection<Path> baseDirectories) {
        Objects.requireNonNull(baseDirectories, "null baseDirectories");
        return this.withLocalRepositories(baseDirectories.stream().map(LocalRepository::new).collect(Collectors.toList()));
    }

    @Override
    public RepositorySystemSession.SessionBuilder withLocalRepositories(LocalRepository ... localRepositories) {
        return this.withLocalRepositories(Arrays.asList(localRepositories));
    }

    @Override
    public RepositorySystemSession.SessionBuilder withLocalRepositories(Collection<LocalRepository> localRepositories) {
        Objects.requireNonNull(localRepositories, "null localRepositories");
        this.localRepositories = localRepositories;
        return this;
    }

    @Override
    public RepositorySystemSession.SessionBuilder withRepositoryListener(RepositoryListener ... repositoryListeners) {
        return this.withRepositoryListener(Arrays.asList(repositoryListeners));
    }

    @Override
    public RepositorySystemSession.SessionBuilder withRepositoryListener(Collection<RepositoryListener> repositoryListeners) {
        this.repositoryListener.addAll(repositoryListeners);
        return this;
    }

    @Override
    public RepositorySystemSession.SessionBuilder withTransferListener(TransferListener ... transferListeners) {
        return this.withTransferListener(Arrays.asList(transferListeners));
    }

    @Override
    public RepositorySystemSession.SessionBuilder withTransferListener(Collection<TransferListener> transferListeners) {
        this.transferListener.addAll(transferListeners);
        return this;
    }

    @Override
    public RepositorySystemSession.SessionBuilder withRepositorySystemSession(RepositorySystemSession session) {
        Objects.requireNonNull(session, "repository system session cannot be null");
        this.setOffline(session.isOffline());
        this.setIgnoreArtifactDescriptorRepositories(session.isIgnoreArtifactDescriptorRepositories());
        this.setResolutionErrorPolicy(session.getResolutionErrorPolicy());
        this.setArtifactDescriptorPolicy(session.getArtifactDescriptorPolicy());
        this.setChecksumPolicy(session.getChecksumPolicy());
        this.setUpdatePolicy(session.getUpdatePolicy());
        this.setMetadataUpdatePolicy(session.getMetadataUpdatePolicy());
        this.setLocalRepositoryManager(session.getLocalRepositoryManager());
        this.setWorkspaceReader(session.getWorkspaceReader());
        this.setRepositoryListener(session.getRepositoryListener());
        this.setTransferListener(session.getTransferListener());
        this.setSystemProperties((Map)session.getSystemProperties());
        this.setUserProperties((Map)session.getUserProperties());
        this.setConfigProperties((Map)session.getConfigProperties());
        this.setMirrorSelector(session.getMirrorSelector());
        this.setProxySelector(session.getProxySelector());
        this.setAuthenticationSelector(session.getAuthenticationSelector());
        this.setArtifactTypeRegistry(session.getArtifactTypeRegistry());
        this.setDependencyTraverser(session.getDependencyTraverser());
        this.setDependencyManager(session.getDependencyManager());
        this.setDependencySelector(session.getDependencySelector());
        this.setVersionFilter(session.getVersionFilter());
        this.setDependencyGraphTransformer(session.getDependencyGraphTransformer());
        this.setData(session.getData());
        this.setCache(session.getCache());
        this.setSystemScopeHandler(session.getSystemScopeHandler());
        return this;
    }

    @Override
    public RepositorySystemSession.CloseableSession build() {
        return new DefaultCloseableSession(this.sessionIdSupplier.get(), this.offline, this.ignoreArtifactDescriptorRepositories, this.resolutionErrorPolicy, this.artifactDescriptorPolicy, this.checksumPolicy, this.artifactUpdatePolicy, this.metadataUpdatePolicy, this.localRepositoryManager, this.localRepositories, this.workspaceReader, this.repositoryListener, this.transferListener, DefaultSessionBuilder.copySafe(this.systemProperties, String.class), DefaultSessionBuilder.copySafe(this.userProperties, String.class), DefaultSessionBuilder.copySafe(this.configProperties, Object.class), this.mirrorSelector, this.proxySelector, this.authenticationSelector, this.artifactTypeRegistry, this.dependencyTraverser, this.dependencyManager, this.dependencySelector, this.versionFilter, this.dependencyGraphTransformer, this.sessionDataSupplier.get(), this.repositoryCacheSupplier.get(), this.systemScopeHandler, this.onSessionCloseHandlers, this.repositorySystem, this.repositorySystemLifecycle);
    }

    private static <T> Map<String, T> copySafe(Map<?, ?> table, Class<T> valueType) {
        HashMap<String, T> map;
        if (table == null || table.isEmpty()) {
            map = new HashMap<String, T>();
        } else {
            map = new HashMap((int)((float)table.size() / 0.75f) + 1);
            for (Map.Entry<?, ?> entry : table.entrySet()) {
                Object value;
                Object key = entry.getKey();
                if (!(key instanceof String) || !valueType.isInstance(value = entry.getValue())) continue;
                map.put(key.toString(), valueType.cast(value));
            }
        }
        return map;
    }
}

