/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.synccontext.named;

import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.TreeSet;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.named.NamedLockKey;

public class GAVNameMapper
implements NameMapper {
    private final boolean fileSystemFriendly;
    private final String artifactPrefix;
    private final String artifactSuffix;
    private final String metadataPrefix;
    private final String metadataSuffix;
    private final String fieldSeparator;

    public GAVNameMapper(boolean fileSystemFriendly, String artifactPrefix, String artifactSuffix, String metadataPrefix, String metadataSuffix, String fieldSeparator) {
        this.fileSystemFriendly = fileSystemFriendly;
        this.artifactPrefix = Objects.requireNonNull(artifactPrefix);
        this.artifactSuffix = Objects.requireNonNull(artifactSuffix);
        this.metadataPrefix = Objects.requireNonNull(metadataPrefix);
        this.metadataSuffix = Objects.requireNonNull(metadataSuffix);
        this.fieldSeparator = Objects.requireNonNull(fieldSeparator);
    }

    @Override
    public boolean isFileSystemFriendly() {
        return this.fileSystemFriendly;
    }

    @Override
    public Collection<NamedLockKey> nameLocks(RepositorySystemSession session, Collection<? extends Artifact> artifacts, Collection<? extends Metadata> metadatas) {
        TreeSet<NamedLockKey> keys = new TreeSet<NamedLockKey>(Comparator.comparing(NamedLockKey::name));
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                keys.add(NamedLockKey.of(GAVNameMapper.getArtifactName(artifact, this.artifactPrefix, this.fieldSeparator, this.artifactSuffix), GAVNameMapper.getArtifactName(artifact, "", ":", "")));
            }
        }
        if (metadatas != null) {
            for (Metadata metadata : metadatas) {
                keys.add(NamedLockKey.of(GAVNameMapper.getMetadataName(metadata, this.metadataPrefix, this.fieldSeparator, this.metadataSuffix), GAVNameMapper.getMetadataName(metadata, "", ":", "")));
            }
        }
        return keys;
    }

    private static String getArtifactName(Artifact artifact, String prefix, String separator, String suffix) {
        return prefix + artifact.getGroupId() + separator + artifact.getArtifactId() + separator + artifact.getBaseVersion() + suffix;
    }

    private static String getMetadataName(Metadata metadata, String prefix, String separator, String suffix) {
        String name = prefix;
        if (!metadata.getGroupId().isEmpty()) {
            name = name + metadata.getGroupId();
            if (!metadata.getArtifactId().isEmpty()) {
                name = name + separator + metadata.getArtifactId();
                if (!metadata.getVersion().isEmpty()) {
                    name = name + separator + metadata.getVersion();
                }
            }
        }
        return name + suffix;
    }

    public static NameMapper gav() {
        return new GAVNameMapper(false, "artifact:", "", "metadata:", "", ":");
    }

    public static NameMapper fileGav() {
        return new GAVNameMapper(true, "artifact~", ".lock", "metadata~", ".lock", "~");
    }
}

