/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.synccontext.named;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.MultiRuntimeException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.RepositorySystemLifecycle;
import org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import org.eclipse.aether.internal.impl.synccontext.named.NamedLockFactoryAdapter;
import org.eclipse.aether.internal.impl.synccontext.named.NamedLockFactoryAdapterFactory;
import org.eclipse.aether.named.NamedLockFactory;
import org.eclipse.aether.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class NamedLockFactoryAdapterFactoryImpl
implements NamedLockFactoryAdapterFactory {
    public static final String DEFAULT_FACTORY_NAME = "file-lock";
    public static final String DEFAULT_NAME_MAPPER_NAME = "file-gav";
    public static final String CONFIG_PROP_FACTORY_KEY = "aether.syncContext.named.factory";
    public static final String CONFIG_PROP_NAME_MAPPER_KEY = "aether.syncContext.named.nameMapper";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Map<String, NamedLockFactory> factories;
    protected final String defaultFactoryName;
    protected final Map<String, NameMapper> nameMappers;
    protected final String defaultNameMapperName;

    @Inject
    public NamedLockFactoryAdapterFactoryImpl(Map<String, NamedLockFactory> factories, Map<String, NameMapper> nameMappers, RepositorySystemLifecycle lifecycle) {
        this(factories, DEFAULT_FACTORY_NAME, nameMappers, DEFAULT_NAME_MAPPER_NAME, lifecycle);
    }

    public NamedLockFactoryAdapterFactoryImpl(Map<String, NamedLockFactory> factories, String defaultFactoryName, Map<String, NameMapper> nameMappers, String defaultNameMapperName, RepositorySystemLifecycle lifecycle) {
        this.factories = Objects.requireNonNull(factories);
        this.defaultFactoryName = Objects.requireNonNull(defaultFactoryName);
        this.nameMappers = Objects.requireNonNull(nameMappers);
        this.defaultNameMapperName = Objects.requireNonNull(defaultNameMapperName);
        lifecycle.addOnSystemEndedHandler(this::shutdown);
        this.logger.debug("Created adapter factory; available factories {}; available name mappers {}", (Object)factories.keySet(), (Object)nameMappers.keySet());
    }

    @Override
    public NamedLockFactoryAdapter getAdapter(RepositorySystemSession session) {
        return this.createAdapter(session);
    }

    protected NamedLockFactoryAdapter createAdapter(RepositorySystemSession session) {
        String nameMapperName = Objects.requireNonNull(this.getNameMapperName(session));
        String factoryName = Objects.requireNonNull(this.getFactoryName(session));
        NameMapper nameMapper = this.selectNameMapper(nameMapperName);
        NamedLockFactory factory = this.selectFactory(factoryName);
        this.logger.debug("Creating adapter using nameMapper '{}' and factory '{}'", (Object)nameMapperName, (Object)factoryName);
        return new NamedLockFactoryAdapter(nameMapper, factory);
    }

    protected String getFactoryName(RepositorySystemSession session) {
        return ConfigUtils.getString(session, this.getDefaultFactoryName(), CONFIG_PROP_FACTORY_KEY);
    }

    protected String getDefaultFactoryName() {
        return this.defaultFactoryName;
    }

    protected String getNameMapperName(RepositorySystemSession session) {
        return ConfigUtils.getString(session, this.getDefaultNameMapperName(), CONFIG_PROP_NAME_MAPPER_KEY);
    }

    protected String getDefaultNameMapperName() {
        return this.defaultNameMapperName;
    }

    protected NamedLockFactory selectFactory(String factoryName) {
        NamedLockFactory factory = this.factories.get(factoryName);
        if (factory == null) {
            throw new IllegalArgumentException("Unknown NamedLockFactory name: '" + factoryName + "', known ones: " + this.factories.keySet());
        }
        return factory;
    }

    protected NameMapper selectNameMapper(String nameMapperName) {
        NameMapper nameMapper = this.nameMappers.get(nameMapperName);
        if (nameMapper == null) {
            throw new IllegalArgumentException("Unknown NameMapper name: '" + nameMapperName + "', known ones: " + this.nameMappers.keySet());
        }
        return nameMapper;
    }

    protected void shutdown() {
        this.logger.debug("Shutting down adapter factory; available factories {}; available name mappers {}", (Object)this.factories.keySet(), (Object)this.nameMappers.keySet());
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Map.Entry<String, NamedLockFactory> entry : this.factories.entrySet()) {
            try {
                this.logger.debug("Shutting down '{}' factory", (Object)entry.getKey());
                entry.getValue().shutdown();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        MultiRuntimeException.mayThrow("Problem shutting down factories", exceptions);
    }
}

