/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.transport.http;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.spi.connector.transport.http.ChecksumExtractorStrategy;

@Singleton
@Named(value="xChecksum")
public final class XChecksumExtractor
extends ChecksumExtractorStrategy {
    public static final String NAME = "xChecksum";

    @Override
    public Map<String, String> extractChecksums(Function<String, String> headerGetter) {
        HashMap<String, String> result = new HashMap<String, String>();
        String value = headerGetter.apply("x-checksum-sha1");
        if (value != null) {
            result.put("SHA-1", value);
        }
        if ((value = headerGetter.apply("x-checksum-md5")) != null) {
            result.put("MD5", value);
        }
        if (!result.isEmpty()) {
            return result;
        }
        value = headerGetter.apply("x-goog-meta-checksum-sha1");
        if (value != null) {
            result.put("SHA-1", value);
        }
        if ((value = headerGetter.apply("x-goog-meta-checksum-md5")) != null) {
            result.put("MD5", value);
        }
        return result.isEmpty() ? null : result;
    }
}

